/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.informgrid;

import com.queplix.core.client.app.vo.InFormGridFieldMeta;
import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

public class QInformGrid implements QFormElement {
    /**
     * happen when user wants to link new record(s) to entity
     */
    public final static int LINK_BUTTON_INDEX = 0x000001;
    /**
     * happen when user wants to unlink record(s)
     */
    public final static int UNLINK_BUTTON_INDEX = 0x000002;
    /**
     * happen when user wants to set up the filters
     */
    public final static int FILTERS_BUTTON_INDEX = 0x000004;
    /**
     * happen when form and hence in-form grid control change it's state.
     */
    public final static int CONTROL_STATE_CHANGED_INDEX = 0x000008;
    /**
     * happen when user select a record.
     */
    public final static int RECORD_SELECTION_CHANGED_INDEX = 0x000010;
    /**
     * happen when user selected records in filtering dialog, or set number of
     * filters
     */
    public final static int FILTERS_WERE_SET_INDEX = 0x000040;

    public final static int ALL_BUTTONS = LINK_BUTTON_INDEX
            | UNLINK_BUTTON_INDEX | FILTERS_BUTTON_INDEX;

    public final static String INFORMGRID_STYLE_NAME_PREFIX = "informGrid_";

    private QInformGridControllerImpl controller;
    private QInformGridModelImpl model;
    private QInformGridViewImpl view;

    public QInformGrid(InFormGridFieldMeta meta) {
        model = new QInformGridModelImpl(meta);
        view = new QInformGridViewImpl(model);
        controller = new QInformGridControllerImpl(model, view);
    }

    public QInformGrid() {
        this(null);
    }

    public QInformGridController getController() {
        return controller;
    }

    public QInformGridModel getModel() {
        return model;
    }

    public QFormElementModel getBaseModel() {
        return model;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }

}
