/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.informgrid;

/**
 * Implements in-form selected state
 *
 * @author Sergey Kozmin
 * @since 06.10.2006, 13:18:07
 */
class SelectedGridState extends AbstractState {
    public SelectedGridState(StateContext context) {
        super(context, SELECTED_STATE);
    }

    public void enterToState() {
        context.showLinkButtons();
        context.disableLinkButtons();
        context.hideFilterButton();
    }

    public void actionPerformed(int action)
            throws IncorrectGridActionPerformed {
        switch(action) {
            case QInformGrid.CONTROL_STATE_CHANGED_INDEX: {
                changeStateIfAnother();
                break;
            }
            case QInformGrid.RECORD_SELECTION_CHANGED_INDEX: {
                break;
            }
            default: {
                throw new IncorrectGridActionPerformed(
                        "Internal error! Could not perform the action: "
                                + action + ", in selected state");
            }
        }
    }
}
