/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.listbox;

import com.queplix.core.client.app.vo.ListboxFieldMeta;
import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

public class QListBox implements QFormElement {
    public static final String STYLE_NAME_PREFIX = "listbox_";

    private QListBoxControllerImpl controller;
    private QListBoxViewImpl view;
    private QListBoxModelImpl model;

    public QListBox(ListboxFieldMeta listboxFieldMeta, boolean isEmptyStr,
                    boolean isNullStr, boolean isOrStr, int layout) {
        model = new QListBoxModelImpl(listboxFieldMeta);
        view = new QListBoxViewImpl(model, isEmptyStr, isNullStr, isOrStr,
                layout);
        controller = new QListBoxControllerImpl(model, view);
    }

    public QListBox(ListboxFieldMeta listboxFieldMeta, int layout) {
        this(listboxFieldMeta, true, true, true, layout);
    }

    public QListBoxController getController() {
        return controller;
    }

    public QFormElementModel getBaseModel() {
        return model;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }

    public QListBoxModel getModel() {
        return model;
    }
}
