/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.controls.listbox;

import com.queplix.core.client.app.vo.FieldOnDemandData;
import com.queplix.core.client.app.vo.ListBoxOnDemandData;
import com.queplix.core.client.app.vo.ListboxFieldData;
import com.queplix.core.client.app.vo.ListboxFieldMeta;
import com.queplix.core.client.app.vo.SubsetData;
import com.queplix.core.client.app.vo.SubsetItemMeta;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

class QListBoxModelImpl extends QFormElementModelImpl implements QListBoxModel {
    public QListBoxModelImpl(ListboxFieldMeta listboxFieldMeta) {
        setMeta(listboxFieldMeta);
        setData(new ListboxFieldData(listboxFieldMeta.getFieldID()));
    }

    public ListboxFieldMeta getMeta() {
        if(null == super.getBaseMeta()) {
            setMeta(new ListboxFieldMeta());
        }
        return (ListboxFieldMeta) super.getBaseMeta();
    }

    public void setMeta(ListboxFieldMeta meta) {
        super.setBaseMeta(meta);
    }

    public ListboxFieldData getData() {
        if(null == super.getBaseData()) {
            setData(new ListboxFieldData());
        }
        return ((ListboxFieldData) super.getBaseData());
    }

    public void setData(ListboxFieldData data) {
        super.setBaseData(data);
    }

    public int getItemCount() {
        return this.getMeta().getAvailableChoises().getItems().length;
    }

    public boolean isItemSelected(int idx) {
        long id = this.getMeta().getAvailableChoises().getItems()[idx].getId();
        long[] itemsSelectedId = this.getData().getItemsSelected()
                .getSelectedIDs();
        for(int i = 0; i < itemsSelectedId.length; i++) {
            if(id == itemsSelectedId[i]) {
                return true;
            }
        }
        return false;
    }

    public int getFirstSelectedIdx() {
        int ret = -1;
        if(0 < this.getData().getItemsSelected().getSelectedIDs().length) {
            long firstSelId = this.getData().getItemsSelected()
                    .getSelectedIDs()[0];
            SubsetItemMeta[] itemMetas = this.getMeta().getAvailableChoises()
                    .getItems();
            for(int i = 0; i < itemMetas.length; i++) {
                if(firstSelId == itemMetas[i].getId()) {
                    ret = i;
                }
            }
        }
        return ret;
    }

    public void selectFirstItem() {
        if(0 < this.getMeta().getAvailableChoises().getItems().length) {
            ListboxFieldData lbfd = this.getData();
            lbfd.setItemsSelected(new SubsetData());
            this.setData(lbfd);
        }
    }

    public boolean isValid() {
        return !(getMeta().isRequired() && getData().isEmpty());
    }

    public String getErrorTitle() {
        return DEFAULT_REQUIRED_FIELD_MESSAGE;
    }

    public int getDataType() {
        return THE_TYPE;
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel)
            throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel
                    .getDataType());
        }
        QListBoxModel model = (QListBoxModel) sameTypeControlModel;
//        changeListeners.fireListStructureChanged();
//        changeListeners.fireListSelectionChanged();
        this.setData((ListboxFieldData) model.getData().cloneData());
        this.setMeta(model.getMeta());
    }

    public void setFieldOnDemandData(FieldOnDemandData onDemandData) {
        ListBoxOnDemandData demandData = (ListBoxOnDemandData) onDemandData;
        if(getMeta().isDynamic()) {
            // update meta
            getMeta().setAvailableChoises(demandData.getAvailableChoises());
            fireModelMetaChanged();
        }
        super.setFieldOnDemandData(onDemandData);
    }

    public boolean isLinkable() {
        return true;
    }

    public ListBoxOnDemandData getOnDemandData() {
        return (ListBoxOnDemandData) getFieldOnDemandData();
    }
}
