/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.frames;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.queplix.core.client.app.vo.ProductMeta;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.Icon;
import com.queplix.core.client.common.ui.IconButton;
import com.queplix.core.client.common.ui.IconData;
import com.queplix.core.client.common.StringUtil;
import com.queplix.core.client.common.ui.OkayCancelPopup;

/**
 * @author aliaksandr.melnik
 */
public class AboutFrame extends OkayCancelPopup {
    private static final int DEFAULT_WIDTH = 300;

    public AboutFrame(ProductMeta meta) {
        super("About");

        VerticalPanel vp = new VerticalPanel();
        String name = "";
        if(meta != null) {
            name = meta.getNameAndVersion();
        }
        Label label1 = new Label(name);
        vp.add(label1);

        IconData logoData = new IconData("common/queweb_logo.gif", "http://www.queplix.com");
        vp.add(new Icon(logoData));

        HTML label2 = new HTML(
                "<br/>Queplix Corp.<br/>" +
                        "100 Princeton Overlook Center, 2nd Floor<br/>" +
                        "Princeton, NJ 08540<br/>" +
                        "Telephone: 609-375-2357<br/>" +
                        "<a href='http://www.queplix.com' target='_blank'>www.queplix.com</a><br/><br/>"
                        +
                        "<a href='mailto:info@queplix.com'>info@queplix.com</a><br/>");

        label1.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        label2.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);

        vp.add(label2);

        setWidget(vp);
        setWidth(StringUtil.pixelToSize(DEFAULT_WIDTH));
    }

}
