/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.frames.mainframe;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.GridData;
import com.queplix.core.client.app.vo.GridSearchProperties;
import com.queplix.core.client.app.vo.RowData;

import java.util.List;

/**
 * Contains all operations related directly to grid
 *
 * @author Sergey Kozmin
 * @since 16.04.2007
 */
public interface GridOperations {
    /**
     * Clear grid
     *
     * @param index grid index
     */
    public void clearGrid(FamgMeta.Index index);

    /**
     * Clear grid selection
     *
     * @param index grid index
     */
    public void clearGridSelection(FamgMeta.Index index);

    /**
     * Updates grid row data
     *
     * @param row   row data
     * @param index grid index
     */
    public void setDataForGridRow(RowData row, FamgMeta.Index index);

    /**
     * Set data for whole grid. Old data will be cleared
     *
     * @param gridData          data for grid
     * @param index             grid index
     * @param currentPage       returned data page
     * @param totalRecordsCount total records count
     */
    public void setDataForGrid(GridData gridData,
                               int totalRecordsCount,
                               int currentPage,
                               FamgMeta.Index index);

    /**
     * Select the given record with the single selection type.
     *
     * @param id    id to be selected
     * @param index grid index
     */
    public void selectGridRecord(Long id, FamgMeta.Index index);

    /**
     * Activates the given grid.
     *
     * @param index grid index
     */
    public void activateGrid(FamgMeta.Index index);

    /**
     * @param index grid index
     * @return grid search properties.
     */
    public GridSearchProperties getGridSearchProperties(FamgMeta.Index index);

    /**
     * Returns marked rows list. If grid wasn't initialized, then return empty list.
     * A row is marked if it has single selection or multiple selection.
     *
     * @param index grid index
     * @return list of marked rows.
     */
    public List getMarkedRows(FamgMeta.Index index);
}
