/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.frames.mainframe;

import com.queplix.core.client.app.vo.EntityData;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.common.event.EventSource;

import java.util.Collection;


/**
 * This interface is to be used by mainframe strategies to perform
 * any business operations like set data for forms, get filters from form,
 * select some form, change form state, modify adhoc data, etc.
 * It should not depends on concrete main frame implementation.
 */
public interface OperationContext {
    /**
     * @return interface, that provides adhoc operation context
     */
    public AdhocOperations getAdhocOperations();

    /**
     * @return interface, that provides grid operation context
     */
    public GridOperations getGridOperations();

    /**
     * @return interface, that provides form operation context
     */
    public FormOperations getFormOperations();

    /**
     * @return metadata which was used to build application
     */
    public MetaData getMetaData();

    /**
     * Set data for mainframe
     *
     * @param entitiesList       data for filled entities
     * @param externalFieldsList data for external-fields
     * @param gridData           data for grids. Collection<GridData>
     */
    public void setData(EntityData[] entitiesList,
                        EntityData[] externalFieldsList,
                        Collection gridData);

    /**
     * Set complete status for the operation.
     *
     * @param operation    operation type. See {@link com.queplix.core.client.frames.mainframe.OperationTypes}
     * @param isSuccessful have operation been successfully performed
     * @param index        form index that requested this operation
     */
    public void setOperationStatus(int operation, boolean isSuccessful,
                                   FamgMeta.Index index);

    /**
     * Performs operation with the given form.
     *
     * @param operation operation type. See {@link com.queplix.core.client.frames.mainframe.OperationTypes}
     * @param index     form index that should perform the operation.
     */
    public void performOperation(int operation, FamgMeta.Index index);


    /**
     * @return the base event source.
     */
    public EventSource getEventSource();

    /**
     * Performs mail status check - if there are unread messages changes appearance.
     */
    public void checkMailStatus();
}