/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.frames.mainframe;

import java.util.Set;

/**
 * Interfaces provides all the properties related to main frame view.
 *
 * @author Sergey Kozmin
 * @since 04.05.2007
 */
public interface ViewPropertiesProvider {
    /**
     * The method returns list of interensted events (from enum) or empty list
     * if it doesn't want to get any. Should not return null object.
     *
     * @param formId    form id
     * @param elementId element in this form
     * @return List<{@link FormControlEventTypes}>
     */
    public Set getFormControlListeningEvents(String formId, String elementId);
}
