/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.frames.mainframe.impl;

/**
 * This class is needed to narrow mediator related interfaces and specify the command to be sent to objects.
 * Encapsulate form command data.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 14:11:54
 */
abstract class FormCommand {
    public static final int SET_DATA = 0;
    public static final int CLEAR_DATA = 1;
    public static final int SET_SEARCH_STATUS = 2;
    public static final int SET_CREATE_STATUS = 3;
    public static final int SET_DELETE_STATUS = 4;
    public static final int SET_LOCK_FOR_EDIT_STATUS = 5;
    public static final int SET_UPDATE_STATUS = 6;
    public static final int TURN_FORM_TO_STATE = 7;
    public static final int GET_CAN_FORM_BE_TURNED = 8;
    public static final int SET_ON_DEMAND_CONTROL_DATA = 9;

    /**
     * one of the form command (listed above).
     */
    private int commandID;

    public FormCommand(int commandID) {
        this.commandID = commandID;
    }

    public int getCommandID() {
        return commandID;
    }
}
