/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.frames.mainframe.impl;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents form update event data.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 14:27:50
 */
class UpdateFormEvent extends FormEvent {
    private final static int EVENT_TYPE = UPDATE_EVENT;
    private List data;
    private String rowID;
    private boolean toBeInserted = false;

    /**
     * @param data         collection of {@link com.queplix.core.client.app.vo.FieldData} elements
     * @param rowID        updating row
     * @param toBeInserted should record be inserted to the table.
     */
    public UpdateFormEvent(String rowID, List data, boolean toBeInserted) {
        super(EVENT_TYPE);
        this.toBeInserted = toBeInserted;
        if(data == null) {
            this.data = new ArrayList();
        } else {
            this.data = data;
        }
        if(rowID == null) {
            this.rowID = "unknown updating rowid";
        } else {
            this.rowID = rowID;
        }
    }

    public UpdateFormEvent() {
        this(null, null, false);
    }

    /**
     * Could not be null
     *
     * @return list of filters
     */
    public List getData() {
        return data;
    }

    public void setData(List data) {
        if(data != null) {
            this.data = data;
        }
    }

    public String getRowID() {
        return rowID;
    }

    public void setRowID(String rowID) {
        this.rowID = rowID;
    }

    public boolean isToBeInserted() {
        return toBeInserted;
    }

    public void setToBeInserted(boolean toBeInserted) {
        this.toBeInserted = toBeInserted;
    }
}
