/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.utils.www;

import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

/**
 * <p>Abstract Filter Class</p>
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:23 $
 */
public abstract class AbstractFilter
        implements Filter {

    /**
     * Filter config
     */
    protected FilterConfig filterConfig;

    /**
     * Logger
     */
    protected final AbstractLogger logger = Log.getLog(getClass());

    /**
     * Initialize filter
     *
     * @param filterConfig HTTP filter config
     * @throws ServletException
     */
    public void init(FilterConfig filterConfig)
            throws ServletException {

        // Init
        this.filterConfig = filterConfig;
    }

    /**
     * Destroy filter
     */
    public void destroy() {
        filterConfig = null;
    }
}
