DELIMITER //

-- USE qwoss
-- //
DROP PROCEDURE IF EXISTS QX_SET_USER_RIGHTS
//

DELETE FROM QX_PERMISSION;
//

CREATE PROCEDURE QX_SET_USER_RIGHTS()
BEGIN
    -- select all tables 
    DECLARE done int DEFAULT 0;
    DECLARE view_object_id int;
    DECLARE cur CURSOR FOR
        select pkey from QX_VIEW_OBJECTS where type=0;
    DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
     

    OPEN cur;
    -- fill temporary table qx_maxkeys
    FETCH cur INTO view_object_id;
    WHILE done = 0 DO
        CALL QX_NEXT_KEY('QX_PERMISSION', 1, @id);
        SET @state=CONCAT('INSERT INTO QX_PERMISSION (PERMISSION_ID,ROLE_ID,',
                          'ACCESS_LEVEL,PERMISSION_OBJECT_TYPE,OBJECT_ID) VALUES ',
                          '(',@id, ',', 0, ',', 3, ',', 0, ',', view_object_id,')');
        PREPARE stmt FROM @state;
        EXECUTE stmt;
	FETCH cur INTO view_object_id;
    END WHILE;
    SET done = 0;
    CLOSE cur;
END
//


CALL QX_SET_USER_RIGHTS()
//

DROP PROCEDURE QX_SET_USER_RIGHTS
//