package com.queplix.installer;

import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;

/**
 * @author dmitry.antonov
 */
public class QuewebInstallerListener extends SimpleInstallerListener {


    public QuewebInstallerListener() {
        super();
    }

    /*
    * (non-Javadoc)
    *
    * @see com.izforge.izpack.compiler.InstallerListener#beforePacks(com.izforge.izpack.installer.AutomatedInstallData,
    * int, com.izforge.izpack.util.AbstractUIProgressHandler)
    */
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        String portsSet = idata.getVariable("JBOSS_PORTS_SET");
        String quewebPort = "8080";
        String jndiPort = "1099";
        if (portsSet.equals("ports-01")) {
            quewebPort = "8180";
            jndiPort = "1199";
        } else if (portsSet.equals("ports-02")) {
            quewebPort = "8280";
            jndiPort = "1299";
        } else if (portsSet.equals("ports-03")) {
            quewebPort = "8380";
            jndiPort = "1399";
        }
        idata.setVariable("QUEWEB_PORT", quewebPort);
        idata.setVariable("JNDI_PORT", jndiPort);
    }
}
