/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.actions;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.services.XAAction;
import com.queplix.core.utils.DateHelper;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.qwoss.gen.SolutionObject;
import com.queplix.qwoss.gen.SolutionObjectHandler;
import com.queplix.qwoss.utils.SolutionHelper;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;


/**
 * Retires solutions action
 *
 * @author [LIV] Ladnev Ilya
 * @version $Revision: 1.2 $ $Date: 2006/08/24 16:21:58 $
 */
public class RetireSolutionsAction extends XAAction {
    /* (non-Javadoc)
     * @see Action#perform
     */
    public Serializable perform() {

        long time = System.currentTimeMillis();
        INFO("Sending scheduled reports...");

        // Initialization.
        CacheObjectManager com = getContext().getCOM();
        JEOManagerLocal jeoManager = (JEOManagerLocal) com.getLocalObject(
                JNDINames.JEOManager, JEOManagerLocalHome.class);
//        ReportManagerLocal reportManager = ( ReportManagerLocal ) com.getLocalObject( JNDINames.ReportManager, ReportManagerLocalHome.class );
        LogonSession ls = getContext().getLogonSession();

        try {
            // Get solutions, ready to be retired.
            List hnds = SolutionObjectHandler.selectSolutionsToRetire(
                    jeoManager, ls);
            if(hnds == null || hnds.isEmpty()) {
                INFO("No expired solutions found.");
                return null;
            }

            // Process solution.
            //Date now = DateHelper.getNowDate();
            for(Iterator it = hnds.iterator(); it.hasNext();) {

                JEObjectHandler hnd = (JEObjectHandler) it.next();
                SolutionObject obj = (SolutionObject) hnd.getJEObject();

                int status = obj.getQw_solutionstatus();
                if(status == SolutionHelper.RETIRED_STATUS) {
                    INFO("Solution is already in 'Retired' status.");
                    return null;
                }

                obj.setQw_solutionstatus(SolutionHelper.RETIRED_STATUS);
                obj.setQw_lastmodified(DateHelper.getNowDate());
                obj.setQw_modifiedby(ls.getUser().getUserID());

                hnd.commit();
            }

        } catch (EQLException ex) {
            ERROR(ex);
            throw new GenericSystemException(ex);
        }

        // Ok.
        INFO("Completed, time = " + (System.currentTimeMillis() - time)
                + " ms.");
        return null;

    }

}
