/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.update;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.qwoss.gen.NotifRecipientFieldObject;
import com.queplix.qwoss.gen.NotifRecipientFieldObjectHandler;
import com.queplix.qwoss.gen.TicketNotificationObject;
import com.queplix.qwoss.gen.TicketNotificationObjectHandler;
import com.queplix.qwoss.utils.TicketNotificationHelper;
import java.util.ArrayList;
import java.util.List;

/**
 * Description.
 *
 * @author rustem.nizamiev
 */

public class TicketNotificationUpdate extends EntityUpdate {

    /*
     * (non-Javadoc)
     * 
     * @see EntityUpdate#beforeUpdate()
     */
    public int beforeUpdate() throws EQLException {

        // Initialization.
        JEOManagerLocal jeoManager = (JEOManagerLocal) getCOM().
            getLocalObject(JNDINames.JEOManager, JEOManagerLocalHome.class);
        // Get current record.
        JEObjectHandler hnd = getJEOHandler(jeoManager, TicketNotificationObjectHandler.class);
        TicketNotificationObject obj = (TicketNotificationObject) hnd.getJEObject();
        // Initialize delete candidates list
        ArrayList<Long> deleteCandidates = new ArrayList<Long>();
        // Check recipient
        List notifRecipientHandlers = obj.dsQw_recipient(NotifRecipientFieldObjectHandler.class);
        // for all recipients do --
        if(notifRecipientHandlers != null) {
            for(int j = 0; j < notifRecipientHandlers.size(); j++) {
                NotifRecipientFieldObjectHandler notifRecipientFieldObjectHandler
                        = (NotifRecipientFieldObjectHandler) notifRecipientHandlers.get(j);
                NotifRecipientFieldObject notifRecipientFieldObject = 
                    (NotifRecipientFieldObject) notifRecipientFieldObjectHandler.getJEObject();
                Long notifRecipientPKey = notifRecipientFieldObject.getQw_id();
                if(deleteCandidates.contains(notifRecipientPKey)) 
                    continue;
                if(notifRecipientFieldObjectHandler.getEqlResRecord().doDelete()){
                    deleteCandidates.add(notifRecipientPKey);
                    continue;
                }
                Integer method = obj.getQw_sendmode();
                Integer recipinet = notifRecipientFieldObject.getQw_recipient();
                if(recipinet == null) {
                    throw new EQLException("Recipient is needed.");
                }
                switch(recipinet.intValue()) {
                    case TicketNotificationHelper.AGENT_RECIPIENT:
                    case TicketNotificationHelper.OWNER_RECIPIENT:
                        if(method == null) {
                            throw new EQLException("Please supply a notification method in 'Then Send' field");
                        }
                        break;
                    case TicketNotificationHelper.CUSTOMER_RECIPIENT:
                        if(method == null || method.intValue() != TicketNotificationHelper.EMAIL_METHOD) {
                            throw new EQLException("Only 'Email' is available for the Customer as value for 'Then Send'");
                        }
                        break;
                    case TicketNotificationHelper.EMAIL_TO_RECIPIENT:
                        if(method == null || method.intValue() != TicketNotificationHelper.EMAIL_METHOD) {
                            throw new EQLException("Only 'Email' is available for this recepient mode as value for 'Then Send'");
                        }
                        if(obj.getQw_email() == null || obj.getQw_email().trim().length() < 1) {
                            throw new EQLException("Please specify email address");
                        }
                        break;
                }
            }
        }
        return CONTINUE;
    }
}
