/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.utils;

import com.queplix.qwoss.notification.NotificationHelper;

/**
 * <p>Ticket escalation constants</p>
 *
 * @author rustem.nizamiev
 */

public class TicketEscalationHelper extends NotificationHelper{

    // notification recipients
    public static final int ASSIGNED_WORKGROUP_RECIPIENT = 0;
    public static final int ASSIGNED_EMPLOYEE_RECIPIENT = 1;
    public static final int ASSIGNED_EMAIL_RECIPIENT = 2;

    // Escalation 'Fire If'.
    public static final int NOT_CLOSED_FIREIF = 0;
    public static final int NOT_UPDATED_FIREIF = 1;
    public static final int NOT_ASSIGNED_FIREIF = 2;

    // Escalation delay units.
    public final static int MINUTES_DELAY_UNITS = 0;
    public final static int HOURS_DELAY_UNITS = 1;
    public static final int DAYS_DELAY_UNITS = 2;
    public static final int WORKDAYS_DELAY_UNITS = 3;

}
