/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.app.rpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.EmailComposeRequestObject;

import java.util.Collection;

/**
 * Application specific AppRPC methods.
 *
 * @author Sultan Tezadov
 * @since 12 Feb 2007
 */
public class CustomRPC extends RPC {
    private static final String CUSTOM_SERVICE = "customservice";

    private static CustomRPC instance;

    private static CustomServiceAsync customService;

    /**
     * Singleton
     */
    protected CustomRPC() {
    }

    public static CustomRPC getCustomRPC() {
        if(instance == null) {
            instance = new CustomRPC();
        }
        return instance;
    }

    private CustomServiceAsync getCustomServiceAsync() {
        if(customService == null) {
            customService = (CustomServiceAsync) GWT.create(
                    CustomService.class);
            ServiceDefTarget endpoint = (ServiceDefTarget) customService;
            String moduleRelativeURL = GWT.getModuleBaseURL() + CUSTOM_SERVICE;
            endpoint.setServiceEntryPoint(moduleRelativeURL);
        }
        return customService;
    }

    public void createTicketInteractionLink(Long ticketID, Long interID,
                                            QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().createTicketInteractionLink(ticketID, interID,
                callback.callback);
    }

    public void createAttachmentSolutionLink(Long atachmentId, Long solutionId,
                                             QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().createAttachmentSolutionLink(atachmentId,
                solutionId, callback.callback);
    }

    public void createAttachmentTicketLink(Long atachmentId, Long ticketId,
                                           QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().createAttachmentTicketLink(atachmentId,
                ticketId, callback.callback);
    }

    public void checkEmailAccount(Long accountPkey, String accountName,
                                  QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().checkEmailAccount(accountPkey, accountName,
                callback.callback);
    } // checkEmailAccount(Long, String, QAsyncCallback) : Boolean

    public void startTask(Long taskID, QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().startTask(taskID, callback.callback);
    }

    public void stopTask(Long taskID, QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().stopTask(taskID, callback.callback);
    }

    public void sendReply(EmailComposeRequestObject request, int objectType,
                          long objectId, QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().sendReply(request, objectType, objectId,
                callback.callback);
    }

    public void getAccountReplyEmail(Long accountId, QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().getAccountReplyEmail(accountId,
                callback.callback);
    }

    public void getFromAndToEmail(int objectType, long objectId,
                                  boolean isCustomer, Long initCustomerId,
                                  QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().getFromAndToEmail(objectType, objectId,
                isCustomer, initCustomerId, callback.callback);
    }

    public void deleteInbox(Collection inboxPkeys, QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().deleteInbox(inboxPkeys, callback.callback);
    }

    public void deleteAttachment(Collection attachmentPkeys,
                                 QAsyncCallback callback) {
        notifyRequestStarted();
        getCustomServiceAsync().deleteAttachment(attachmentPkeys,
                callback.callback);
    }

}
