/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.FieldDataRequest;
import com.queplix.core.client.app.vo.MultiselectDataRequest;
import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;

/**
 * Description:
 *
 * @author rustem.nizamiev
 * @since 15  2007 ., 20:35
 */
final class HistoryManagmentHandler extends OSSOperationStrategy {
    public static final String TABLEFIELD_FIELD_NAME
            = "field"; //filtering field
    public static final String HISTORY_TABLE_ID_IN_THIS_FORM
            = "his_table_id"; //filtering table id in this form
    public static final String HISTORY_TABLE_ID_FIELD_NAME
            = "his_table_id"; //filter on historyfield.admin (field "id")

    protected boolean processControlDataRequest(FieldDataRequest request) {
        String elementID = request.getElementID();
        if(TABLEFIELD_FIELD_NAME.equalsIgnoreCase(elementID)) {
            MultiselectDataRequest multiReq = (MultiselectDataRequest) request;
            FieldData tableId = getOperationContext().getFormOperations()
                    .getFieldData(
                            getFormIndex(), HISTORY_TABLE_ID_IN_THIS_FORM);
            if(!tableId.isEmpty()) {
                FieldData cloned = tableId.cloneData();
                cloned.setFieldID(HISTORY_TABLE_ID_FIELD_NAME);
                multiReq.setAdditionalFilter(cloned);
            }
        }
        return super.processControlDataRequest(request);
    }
}
