/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.vo.EntityReferenceDataRequest;
import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.FieldDataRequest;
import com.queplix.core.client.app.vo.ListboxFieldData;
import com.queplix.core.client.app.vo.TextboxFieldData;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;
import com.queplix.core.client.frames.mainframe.FormOperations;

/**
 * Description.
 *
 * @author Ilya Ladnev
 * @since 02 Mar 2007
 */
final class WorkflowHandler extends OSSOperationStrategy {

    private static final String STATUSFROM_FIELD_NAME = "qw_statusfrom";
    private static final String STATUSTO_FIELD_NAME = "qw_statusto";
    private static final String OBJECTTYPE_FIELD_NAME = "qw_objecttype";
    private static final String STATUSFROM_OBJECT_FIELD_NAME = "object";
    private static final String STATUSTO_OBJECT_FIELD_NAME = "object";

    protected boolean processControlDataRequest(FieldDataRequest request) {
        String elementID = request.getElementID();
        FormOperations context = getOperationContext().getFormOperations();
        if(STATUSFROM_FIELD_NAME.equalsIgnoreCase(elementID)) {
            EntityReferenceDataRequest theRequest
                    = (EntityReferenceDataRequest) request;

            ListboxFieldData objectData = (ListboxFieldData) context
                    .getFieldData(
                            getFormIndex(), OBJECTTYPE_FIELD_NAME);
            long[] ids = objectData.getItemsSelected().getSelectedIDs();
            if(ids.length > 0) {
                FieldData cloned = new TextboxFieldData(
                        STATUSFROM_OBJECT_FIELD_NAME, "" + ids[0]);
                theRequest.setAdditionalFilterForRequestingEntity(cloned);
            } else {
                DialogHelper.showModalMessageDialog(
                        "Please select Object type first!");
                return BREAK;
            }
        } else if(STATUSTO_FIELD_NAME.equalsIgnoreCase(elementID)) {
            EntityReferenceDataRequest theRequest
                    = (EntityReferenceDataRequest) request;

            ListboxFieldData objectData = (ListboxFieldData) context
                    .getFieldData(
                            getFormIndex(), OBJECTTYPE_FIELD_NAME);
            long[] ids = objectData.getItemsSelected().getSelectedIDs();
            if(ids.length > 0) {
                FieldData cloned = new TextboxFieldData(
                        STATUSTO_OBJECT_FIELD_NAME, "" + ids[0]);
                theRequest.setAdditionalFilterForRequestingEntity(cloned);
            } else {
                DialogHelper.showModalMessageDialog(
                        "Please select Object type first!");
                return BREAK;
            }
        }
        return super.processControlDataRequest(request);
    }
}
