/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.qwoss.server.app.rpc;

import com.queplix.core.client.app.rpc.DisplayableException;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.WebLoginManager;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.jeo.gen.AttachmentObjectHandler;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;
import com.queplix.qwoss.gen.AttachmentObjectsObject;
import com.queplix.qwoss.gen.AttachmentObjectsObjectHandler;
import com.queplix.qwoss.utils.ApplicationHelper;

import javax.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;

/**
 * Application custom RPC methods implementation.
 *
 * @author Sergei Savchuk
 */
public class AttachmentRPCHelper {

    // Logger
    private static final AbstractLogger logger = Log.getLog(
            TicketLinkRPCHelper.class);

    public static Boolean createAttachmentObjectLink(Long attachmentId,
                                                     Long objectId,
                                                     Integer objectType,
                                                     HttpServletRequest request)
            throws DisplayableException, EQLException {
        LogonSession ls = WebLoginManager.getLogonSession(request);
        JEOManagerLocal jeoManager = (JEOManagerLocal)
                new CacheObjectManager().getLocalObject(JNDINames.JEOManager,
                        JEOManagerLocalHome.class);
        logger.INFO("createAttachmentObjectLink: Attachment # " + attachmentId
                + " " +
                "is going to be linked to object # " + objectId + " of object type " + objectType);
        AttachmentObjectsObjectHandler attachHnd
                = (AttachmentObjectsObjectHandler) AttachmentObjectsObjectHandler
                .
                        selectByIDs(jeoManager, ls, attachmentId.longValue(),
                                objectId.longValue(),
                                objectType);
        if (attachHnd == null) { //there is no duplicate link
            JEObjectHandler linkHnd = jeoManager.create(ls,
                    AttachmentObjectsObjectHandler.class);
            AttachmentObjectsObject linkObj = (AttachmentObjectsObject) linkHnd
                    .getJEObject();
            linkObj.setAttachment_id(attachmentId);
            linkObj.setObject_id(objectId);
            linkObj.setObject_type(objectType);
            jeoManager.commit(linkHnd);
            logger.INFO("createAttachmentTicketLink: Link for object # "
                    + objectId +  " of object type " + objectType +
                    " and Attachment # " + attachmentId + " is created.");
            return Boolean.TRUE;
        } else {
            logger.WARN("createAttachmentObjectLink: The link already exists.");
            return Boolean.FALSE;
        }

    }

    public static Boolean deleteAttachment(Collection<Long> attachmentIds,
                                           HttpServletRequest request)
            throws EQLException {
        LogonSession ls = WebLoginManager.getLogonSession(request);
        JEOManagerLocal jeoManager = (JEOManagerLocal)
                new CacheObjectManager().getLocalObject(JNDINames.JEOManager,
                        JEOManagerLocalHome.class);
        for(Long attachmentID : attachmentIds) {
            List hndList = AttachmentObjectsObjectHandler.selectByAttachmentID(
                    jeoManager, ls, attachmentID);
            if(hndList != null && !hndList.isEmpty()) {
                for(Object obj : hndList) {
                    AttachmentObjectsObjectHandler linkHnd
                            = (AttachmentObjectsObjectHandler) obj;
                    linkHnd.remove();
                    jeoManager.commit(linkHnd);
                }
            }
            AttachmentObjectHandler attachHnd
                    = (AttachmentObjectHandler) AttachmentObjectHandler
                    .selectByPkey(jeoManager, ls, attachmentID);
            if(attachHnd != null) {
                attachHnd.remove();
                jeoManager.commit(attachHnd);
            } else {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}
