-- ------------- --
-- POPULATE DATA --
-- ------------- --

BEGIN TRANSACTION;


--
-- SYSTEM tables
--

insert into QX_FIELDINFO values ('_FAKE_YES_NO', 'FAKE_COLUMN', 14, 0, 'No');
insert into QX_FIELDINFO values ('_FAKE_YES_NO', 'FAKE_COLUMN', 14, 1, 'Yes');

insert into QX_LANGUAGE values (0, 'en', 'English');
insert into QX_LANGUAGE values (1, 'de', 'German');
insert into QX_LANGUAGE values (2, 'es', 'Spanish');
insert into QX_LANGUAGE values (3, 'fr', 'French');
insert into QX_LANGUAGE values (4, 'it', 'Italian');
insert into QX_LANGUAGE values (5, 'pt', 'Portuguese');

insert into QX_TIMEZONE values (1,'Brazil/Acre','(GMT-05:00) Acre Time',-300)
insert into QX_TIMEZONE values (2,'Asia/Kabul','(GMT+04:30) Afghanistan Time',270)
insert into QX_TIMEZONE values (3,'US/Alaska','(GMT-09:00) Alaska Standard Time',-540)
insert into QX_TIMEZONE values (4,'Asia/Almaty','(GMT+06:00) Alma-Ata Time',360)
insert into QX_TIMEZONE values (5,'Brazil/West','(GMT-04:00) Amazon Time',-240)
insert into QX_TIMEZONE values (6,'Asia/Anadyr','(GMT+12:00) Anadyr Time',720)
insert into QX_TIMEZONE values (7,'Asia/Aqtau','(GMT+05:00) Aqtau Time',300)
insert into QX_TIMEZONE values (8,'Asia/Aqtobe','(GMT+05:00) Aqtobe Time',300)
insert into QX_TIMEZONE values (9,'Asia/Baghdad','(GMT+03:00) Arabia Standard Time',180)
insert into QX_TIMEZONE values (10,'America/Buenos_Aires','(GMT-03:00) Argentine Time',-180)
insert into QX_TIMEZONE values (11,'Asia/Yerevan','(GMT+04:00) Armenia Time',240)
insert into QX_TIMEZONE values (12,'Canada/Atlantic','(GMT-04:00) Atlantic Standard Time',-240)
insert into QX_TIMEZONE values (13,'Asia/Baku','(GMT+04:00) Azerbaijan Time',240)
insert into QX_TIMEZONE values (14,'Atlantic/Azores','(GMT-01:00) Azores Time',-60)
insert into QX_TIMEZONE values (15,'Asia/Dacca','(GMT+06:00) Bangladesh Time',360)
insert into QX_TIMEZONE values (16,'Asia/Thimbu','(GMT+06:00) Bhutan Time',360)
insert into QX_TIMEZONE values (17,'America/La_Paz','(GMT-04:00) Bolivia Time',-240)
insert into QX_TIMEZONE values (18,'Brazil/East','(GMT-03:00) Brasilia Time',-180)
insert into QX_TIMEZONE values (19,'Asia/Brunei','(GMT+08:00) Brunei Time',480)
insert into QX_TIMEZONE values (20,'Atlantic/Cape_Verde','(GMT-01:00) Cape Verde Time',-60)
insert into QX_TIMEZONE values (21,'Africa/Blantyre','(GMT+02:00) Central African Time',120)
insert into QX_TIMEZONE values (22,'Europe/Madrid','(GMT+01:00) Central European Time',60)
insert into QX_TIMEZONE values (23,'Asia/Makassar','(GMT+08:00) Central Indonesia Time',480)
insert into QX_TIMEZONE values (24,'US/Central','(GMT-06:00) Central Standard Time',-360)
insert into QX_TIMEZONE values (25,'America/Havana','(GMT-05:00) Central Standard Time (Cuba)',-300)
insert into QX_TIMEZONE values (26,'Australia/South','(GMT+09:30) Central Standard Time (South Australia)',570)
insert into QX_TIMEZONE values (27,'Pacific/Saipan','(GMT+10:00) Chamorro Standard Time',600)
insert into QX_TIMEZONE values (28,'Pacific/Chatham','(GMT+12:45) Chatham Standard Time',765)
insert into QX_TIMEZONE values (29,'Chile/Continental','(GMT-04:00) Chile Time',-240)
insert into QX_TIMEZONE values (30,'Asia/Choibalsan','(GMT+09:00) Choibalsan Time',540)
insert into QX_TIMEZONE values (31,'Indian/Christmas','(GMT+07:00) Christmas Island Time',420)
insert into QX_TIMEZONE values (32,'Indian/Cocos','(GMT+06:30) Cocos Islands Time',390)
insert into QX_TIMEZONE values (33,'America/Bogota','(GMT-05:00) Colombia Time',-300)
insert into QX_TIMEZONE values (34,'Pacific/Rarotonga','(GMT-10:00) Cook Is. Time',-600)
insert into QX_TIMEZONE values (35,'Etc/UTC','(GMT+00:00) Coordinated Universal Time',0)
insert into QX_TIMEZONE values (36,'Antarctica/Davis','(GMT+07:00) Davis Time',420)
insert into QX_TIMEZONE values (37,'Antarctica/DumontDUrville','(GMT+10:00) Dumont-d''Urville Time',600)
insert into QX_TIMEZONE values (38,'Asia/Jayapura','(GMT+09:00) East Indonesia Time',540)
insert into QX_TIMEZONE values (39,'Pacific/Easter','(GMT-06:00) Easter Is. Time',-360)
insert into QX_TIMEZONE values (40,'Africa/Addis_Ababa','(GMT+03:00) Eastern African Time',180)
insert into QX_TIMEZONE values (41,'Europe/Athens','(GMT+02:00) Eastern European Time',120)
insert into QX_TIMEZONE values (42,'America/Scoresbysund','(GMT-01:00) Eastern Greenland Time',-60)
insert into QX_TIMEZONE values (43,'US/Eastern','(GMT-05:00) Eastern Standard Time',-300)
insert into QX_TIMEZONE values (44,'Australia/Tasmania','(GMT+10:00) Eastern Standard Time (Tasmania)',600)
insert into QX_TIMEZONE values (45,'Australia/Victoria','(GMT+10:00) Eastern Standard Time (Victoria)',600)
insert into QX_TIMEZONE values (46,'America/Guayaquil','(GMT-05:00) Ecuador Time',-300)
insert into QX_TIMEZONE values (47,'Atlantic/Stanley','(GMT-04:00) Falkland Is. Time',-240)
insert into QX_TIMEZONE values (48,'Brazil/DeNoronha','(GMT-02:00) Fernando de Noronha Time',-120)
insert into QX_TIMEZONE values (49,'Pacific/Fiji','(GMT+12:00) Fiji Time',720)
insert into QX_TIMEZONE values (50,'America/Cayenne','(GMT-03:00) French Guiana Time',-180)
insert into QX_TIMEZONE values (51,'Indian/Kerguelen','(GMT+05:00) French Southern & Antarctic Lands Time',300)
insert into QX_TIMEZONE values (52,'Pacific/Galapagos','(GMT-06:00) Galapagos Time',-360)
insert into QX_TIMEZONE values (53,'Pacific/Gambier','(GMT-09:00) Gambier Time',-540)
insert into QX_TIMEZONE values (54,'Asia/Tbilisi','(GMT+04:00) Georgia Time',240)
insert into QX_TIMEZONE values (55,'Africa/Accra','(GMT+00:00) Ghana Mean Time',0)
insert into QX_TIMEZONE values (56,'Pacific/Tarawa','(GMT+12:00) Gilbert Is. Time',720)
insert into QX_TIMEZONE values (57,'Greenwich','(GMT+00:00) Greenwich Mean Time',0)
insert into QX_TIMEZONE values (58,'Asia/Dubai','(GMT+04:00) Gulf Standard Time',240)
insert into QX_TIMEZONE values (59,'America/Guyana','(GMT-04:00) Guyana Time',-240)
insert into QX_TIMEZONE values (60,'US/Hawaii','(GMT-10:00) Hawaii Standard Time',-600)
insert into QX_TIMEZONE values (61,'US/Aleutian','(GMT-10:00) Hawaii-Aleutian Standard Time',-600)
insert into QX_TIMEZONE values (62,'Asia/Hong_Kong','(GMT+08:00) Hong Kong Time',480)
insert into QX_TIMEZONE values (63,'Asia/Hovd','(GMT+07:00) Hovd Time',420)
insert into QX_TIMEZONE values (64,'Asia/Calcutta','(GMT+05:30) India Standard Time',330)
insert into QX_TIMEZONE values (65,'Indian/Chagos','(GMT+06:00) Indian Ocean Territory Time',360)
insert into QX_TIMEZONE values (66,'Asia/Bangkok','(GMT+07:00) Indochina Time',420)
insert into QX_TIMEZONE values (67,'Asia/Tehran','(GMT+03:30) Iran Standard Time',210)
insert into QX_TIMEZONE values (68,'Asia/Irkutsk','(GMT+08:00) Irkutsk Time',480)
insert into QX_TIMEZONE values (69,'Asia/Tel_Aviv','(GMT+02:00) Israel Standard Time',120)
insert into QX_TIMEZONE values (70,'Asia/Tokyo','(GMT+09:00) Japan Standard Time',540)
insert into QX_TIMEZONE values (71,'Asia/Bishkek','(GMT+06:00) Kirgizstan Time',360)
insert into QX_TIMEZONE values (72,'Asia/Seoul','(GMT+09:00) Korea Standard Time',540)
insert into QX_TIMEZONE values (73,'Pacific/Kosrae','(GMT+11:00) Kosrae Time',660)
insert into QX_TIMEZONE values (74,'Asia/Krasnoyarsk','(GMT+07:00) Krasnoyarsk Time',420)
insert into QX_TIMEZONE values (75,'Pacific/Kiritimati','(GMT+14:00) Line Is. Time',840)
insert into QX_TIMEZONE values (76,'Australia/Lord_Howe','(GMT+10:30) Lord Howe Standard Time',630)
insert into QX_TIMEZONE values (77,'Asia/Magadan','(GMT+11:00) Magadan Time',660)
insert into QX_TIMEZONE values (78,'Asia/Kuala_Lumpur','(GMT+08:00) Malaysia Time',480)
insert into QX_TIMEZONE values (79,'Indian/Maldives','(GMT+05:00) Maldives Time',300)
insert into QX_TIMEZONE values (80,'Pacific/Marquesas','(GMT-09:30) Marquesas Time',-570)
insert into QX_TIMEZONE values (81,'Pacific/Kwajalein','(GMT+12:00) Marshall Islands Time',720)
insert into QX_TIMEZONE values (82,'Indian/Mauritius','(GMT+04:00) Mauritius Time',240)
insert into QX_TIMEZONE values (83,'Antarctica/Mawson','(GMT+06:00) Mawson Time',360)
insert into QX_TIMEZONE values (84,'Europe/Moscow','(GMT+03:00) Moscow Standard Time',180)
insert into QX_TIMEZONE values (85,'US/Mountain','(GMT-07:00) Mountain Standard Time',-420)
insert into QX_TIMEZONE values (86,'Asia/Rangoon','(GMT+06:30) Myanmar Time',390)
insert into QX_TIMEZONE values (87,'Pacific/Nauru','(GMT+12:00) Nauru Time',720)
insert into QX_TIMEZONE values (88,'Asia/Katmandu','(GMT+05:45) Nepal Time',345)
insert into QX_TIMEZONE values (89,'Pacific/Noumea','(GMT+11:00) New Caledonia Time',660)
insert into QX_TIMEZONE values (90,'Pacific/Auckland','(GMT+12:00) New Zealand Standard Time',720)
insert into QX_TIMEZONE values (91,'Canada/Newfoundland','(GMT-03:30) Newfoundland Standard Time',-210)
insert into QX_TIMEZONE values (92,'Pacific/Niue','(GMT-11:00) Niue Time',-660)
insert into QX_TIMEZONE values (93,'Pacific/Norfolk','(GMT+11:30) Norfolk Time',690)
insert into QX_TIMEZONE values (94,'Asia/Novosibirsk','(GMT+06:00) Novosibirsk Time',360)
insert into QX_TIMEZONE values (95,'Asia/Omsk','(GMT+06:00) Omsk Time',360)
insert into QX_TIMEZONE values (96,'Asia/Oral','(GMT+05:00) Oral Time',300)
insert into QX_TIMEZONE values (97,'US/Pacific','(GMT-08:00) Pacific Standard Time',-480)
insert into QX_TIMEZONE values (98,'Asia/Karachi','(GMT+05:00) Pakistan Time',300)
insert into QX_TIMEZONE values (99,'Pacific/Palau','(GMT+09:00) Palau Time',540)
insert into QX_TIMEZONE values (100,'Pacific/Port_Moresby','(GMT+10:00) Papua New Guinea Time',600)
insert into QX_TIMEZONE values (101,'America/Asuncion','(GMT-04:00) Paraguay Time',-240)
insert into QX_TIMEZONE values (102,'America/Lima','(GMT-05:00) Peru Time',-300)
insert into QX_TIMEZONE values (103,'Asia/Kamchatka','(GMT+12:00) Petropavlovsk-Kamchatski Time',720)
insert into QX_TIMEZONE values (104,'Asia/Manila','(GMT+08:00) Philippines Time',480)
insert into QX_TIMEZONE values (105,'Pacific/Enderbury','(GMT+13:00) Phoenix Is. Time',780)
insert into QX_TIMEZONE values (106,'America/Miquelon','(GMT-03:00) Pierre & Miquelon Standard Time',-180)
insert into QX_TIMEZONE values (107,'Pacific/Pitcairn','(GMT-08:00) Pitcairn Standard Time',-480)
insert into QX_TIMEZONE values (108,'Pacific/Ponape','(GMT+11:00) Ponape Time',660)
insert into QX_TIMEZONE values (109,'Asia/Qyzylorda','(GMT+06:00) Qyzylorda Time',360)
insert into QX_TIMEZONE values (110,'Indian/Reunion','(GMT+04:00) Reunion Time',240)
insert into QX_TIMEZONE values (111,'Antarctica/Rothera','(GMT-03:00) Rothera Time',-180)
insert into QX_TIMEZONE values (112,'Asia/Sakhalin','(GMT+10:00) Sakhalin Time',600)
insert into QX_TIMEZONE values (113,'Europe/Samara','(GMT+04:00) Samara Time',240)
insert into QX_TIMEZONE values (114,'US/Samoa','(GMT-11:00) Samoa Standard Time',-660)
insert into QX_TIMEZONE values (115,'Indian/Mahe','(GMT+04:00) Seychelles Time',240)
insert into QX_TIMEZONE values (116,'Asia/Singapore','(GMT+08:00) Singapore Time',480)
insert into QX_TIMEZONE values (117,'Pacific/Guadalcanal','(GMT+11:00) Solomon Is. Time',660)
insert into QX_TIMEZONE values (118,'Africa/Johannesburg','(GMT+02:00) South Africa Standard Time',120)
insert into QX_TIMEZONE values (119,'Atlantic/South_Georgia','(GMT-02:00) South Georgia Standard Time',-120)
insert into QX_TIMEZONE values (120,'America/Paramaribo','(GMT-03:00) Suriname Time',-180)
insert into QX_TIMEZONE values (121,'Antarctica/Syowa','(GMT+03:00) Syowa Time',180)
insert into QX_TIMEZONE values (122,'Pacific/Tahiti','(GMT-10:00) Tahiti Time',-600)
insert into QX_TIMEZONE values (123,'Asia/Dushanbe','(GMT+05:00) Tajikistan Time',300)
insert into QX_TIMEZONE values (124,'Asia/Dili','(GMT+09:00) Timor-Leste Time',540)
insert into QX_TIMEZONE values (125,'Pacific/Fakaofo','(GMT-10:00) Tokelau Time',-600)
insert into QX_TIMEZONE values (126,'Pacific/Tongatapu','(GMT+13:00) Tonga Time',780)
insert into QX_TIMEZONE values (127,'Pacific/Truk','(GMT+10:00) Truk Time',600)
insert into QX_TIMEZONE values (128,'Asia/Ashkhabad','(GMT+05:00) Turkmenistan Time',300)
insert into QX_TIMEZONE values (129,'Pacific/Funafuti','(GMT+12:00) Tuvalu Time',720)
insert into QX_TIMEZONE values (130,'Asia/Ulaanbaatar','(GMT+08:00) Ulaanbaatar Time',480)
insert into QX_TIMEZONE values (131,'America/Montevideo','(GMT-03:00) Uruguay Time',-180)
insert into QX_TIMEZONE values (132,'Asia/Tashkent','(GMT+05:00) Uzbekistan Time',300)
insert into QX_TIMEZONE values (133,'Pacific/Efate','(GMT+11:00) Vanuatu Time',660)
insert into QX_TIMEZONE values (134,'America/Caracas','(GMT-04:00) Venezuela Time',-240)
insert into QX_TIMEZONE values (135,'Asia/Vladivostok','(GMT+10:00) Vladivostok Time',600)
insert into QX_TIMEZONE values (136,'Europe/Volgograd','(GMT+03:00) Volgograd Time',180)
insert into QX_TIMEZONE values (137,'Antarctica/Vostok','(GMT+06:00) Vostok Time',360)
insert into QX_TIMEZONE values (138,'Pacific/Wake','(GMT+12:00) Wake Time',720)
insert into QX_TIMEZONE values (139,'Pacific/Wallis','(GMT+12:00) Wallis & Futuna Time',720)
insert into QX_TIMEZONE values (140,'Asia/Jakarta','(GMT+07:00) West Indonesia Time',420)
insert into QX_TIMEZONE values (141,'Pacific/Apia','(GMT-11:00) West Samoa Time',-660)
insert into QX_TIMEZONE values (142,'Africa/Windhoek','(GMT+01:00) Western African Time',60)
insert into QX_TIMEZONE values (143,'Europe/Lisbon','(GMT+00:00) Western European Time',0)
insert into QX_TIMEZONE values (144,'America/Godthab','(GMT-03:00) Western Greenland Time',-180)
insert into QX_TIMEZONE values (145,'Australia/West','(GMT+08:00) Western Standard Time (Australia)',480)
insert into QX_TIMEZONE values (146,'Asia/Yakutsk','(GMT+09:00) Yakutsk Time',540)
insert into QX_TIMEZONE values (147,'Pacific/Yap','(GMT+10:00) Yap Time',600)
insert into QX_TIMEZONE values (148,'Asia/Yekaterinburg','(GMT+05:00) Yekaterinburg Time',300)

insert into QX_COUNTRY values (0, 'US', 'United States', 'en', 'America/Belize');
insert into QX_COUNTRY values (1, 'DE', 'Germany', 'de', 'Africa/Algiers');
insert into QX_COUNTRY values (2, 'FR', 'France', 'de', 'Africa/Algiers');
insert into QX_COUNTRY values (3, 'IT', 'Italy', 'it', 'Africa/Algiers');
insert into QX_COUNTRY values (4, 'ES', 'Spain', 'es', 'UTC');
insert into QX_COUNTRY values (5, 'PT', 'Portugal', 'pt', 'UTC');
insert into QX_COUNTRY values (6, 'GB', 'United Kingdom', 'en', 'UTC');
insert into QX_COUNTRY values (7, 'IE', 'Ireland', 'en', 'UTC');

INSERT INTO dbo.QX_TIME_PATTERN VALUES (0, 'H:mm');
INSERT INTO dbo.QX_TIME_PATTERN VALUES (1, 'h:mm a');
INSERT INTO dbo.QX_TIME_PATTERN VALUES (2, 'HH:mm:ss');

INSERT INTO dbo.QX_DATE_PATTERN VALUES (0, 'd MMM y');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (1, 'd MMM yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (2, 'dd MMM yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (3, 'dd MMM yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (4, 'dd/MM/yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (5, 'ddMMMyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (6, 'ddMMMyyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (7, 'dMMMyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (8, 'M/d/yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (9, 'M/d/yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (10, 'MM/dd/yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (11, 'MM/dd/yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (12, 'MMddyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (13, 'MMddyyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (14, 'MMM d, yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (15, 'MMMM d yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (16, 'MMMM d yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (17, 'MMMM dd yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (18, 'MMMM dd yyyy');
go

--
-- Localization
--

insert into dbo.QX_LOCALIZATION_TYPE values (0, 'Captions');
insert into dbo.QX_LOCALIZATION_TYPE values (1, 'Descriptions');
insert into dbo.QX_LOCALIZATION_TYPE values (2, 'HTML contents');
go

insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (0, 'Label');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (1, 'Focus');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (2, 'Tab');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (3, 'Form');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (4, 'Server Side Message');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (5, 'Client Side Message');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (6, 'Popup Menu');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (7, 'Sub Focus');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (8, 'Context Menu');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (9, 'Form Button')
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (10, 'Html element')
go


--
-- SECURITY
--
insert into QX_ACCESSLEVEL ([pkey], [name]) VALUES (0, 'Read');
insert into QX_ACCESSLEVEL ([pkey], [name]) VALUES (1, 'Write');
insert into QX_ACCESSLEVEL ([pkey], [name]) VALUES (2, 'Owner');
insert into QX_ACCESSLEVEL ([pkey], [name]) VALUES (3, 'Full Control');

INSERT INTO QX_ROLE([role_id], [default_focus_id], [name], [description]) VALUES(0, NULL, 'Administrator', 'This role can manage other users.')
INSERT INTO QX_ROLE([role_id], [default_focus_id], [name], [description]) VALUES(1, NULL, 'User', 'Regular user.')

INSERT INTO QX_VIEW_OBJECT_TYPES ([pkey], [type_description]) VALUES (0, 'Focus');
INSERT INTO QX_VIEW_OBJECT_TYPES ([pkey], [type_description]) VALUES (1, 'SubFocus');
INSERT INTO QX_VIEW_OBJECT_TYPES ([pkey], [type_description]) VALUES (2, 'Tab');
INSERT INTO QX_VIEW_OBJECT_TYPES ([pkey], [type_description]) VALUES (3, 'Form');
--INSERT INTO QX_VIEW_OBJECT_TYPES ([pkey], [type_description]) VALUES (4, 'Field');

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (0, 'CustomerHosts', '127.0.0.1', 'List of hosts that are considered as Customer Hosts', 0);

--
-- EMPLOYEE/WORKGROUP
--
insert into QX_FIELDINFO values ('qx_groupmember', 'notifymethod', 14, 0, 'Alert');
insert into QX_FIELDINFO values ('qx_groupmember', 'notifymethod', 14, 1, 'Email');

insert into QX_FIELDINFO values ('qx_workgroup', 'notifymethod', 14, 0, 'Owners');
insert into QX_FIELDINFO values ('qx_workgroup', 'notifymethod', 14, 1, 'Alert');
insert into QX_FIELDINFO values ('qx_workgroup', 'notifymethod', 14, 2, 'Email');

insert into QX_USER_TYPE values (0, 'database_login');

INSERT INTO QX_USERS ([PKEY], [LOGINNAME], [FULLNAME], [USER_TYPE], [PASSWORD], [EMAIL]) VALUES (0, 'admin', 'Administrator', 0, '', '')
INSERT INTO QX_USERS ([PKEY], [LOGINNAME], [FULLNAME], [USER_TYPE], [PASSWORD], [EMAIL]) VALUES (1, 'system', 'System', 0, '', '')
INSERT INTO QX_WORKGROUP            ([pkey], [name], [description])         VALUES (0, 'Administrators', 'Administrators workgroup.')
INSERT INTO QX_GROUPMEMBER          ([pkey], [EMPLOYEEGROUP], [WORKGROUPGROUP])  VALUES (0, 0, 0)
INSERT INTO QX_WORKGROUP_TO_ROLE    ([pkey], [role_id], [workgroup_id])     VALUES (0, 0, 0)

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (1, 'AdminId', '0', 'Administrator employee ID', 1);--admin id
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (2, 'ReporterId', '1', 'Reporter employee ID', 1);--system id

insert into QX_FIELDINFO values ('qx_user_settings', 'date_position', 14, 0, 'First');
insert into QX_FIELDINFO values ('qx_user_settings', 'date_position', 14, 1, 'Second');

insert into QX_VIEW_OBJECTS([pkey], [name], [type], [parent_object], [order_in_group]) values(0, 'admin', 0, null, 0)
insert into qx_permission([permission_id], [role_id], [access_level], [permission_object_type], [object_id])
values(0, 0, 3, 0, 0)

--
-- ALERTS
--

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (3, 'ALERT_PING_INTERVAL', '60000', 'Default ping interval for alerts', 0);

insert into QX_FIELDINFO values ('qx_alert', 'severity', 14, 0, 'Low');
insert into QX_FIELDINFO values ('qx_alert', 'severity', 14, 1, 'Moderate');
insert into QX_FIELDINFO values ('qx_alert', 'severity', 14, 2, 'Serious');
insert into QX_FIELDINFO values ('qx_alert', 'severity', 14, 3, 'Critical');


--
-- ATTACHMENTS
--

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (4, 'FILE_STORAGE', '/tmp/upload', 'Folder to store attachment files');


--
-- LOGGING
--

insert into QX_LOG_TYPE values ('0', 'error');
insert into QX_LOG_TYPE values ('1', 'warning');
insert into QX_LOG_TYPE values ('2', 'info');
insert into QX_LOG_TYPE values ('3', 'debug');

insert into QX_LOG_CLASS values (0, 'Default', 'QX_LOG');

insert into QX_ERROR_CFG values (100, '*', 'com.queplix.core.modules.services.utils.log.impl.DefMailMsgHnd', null, 0, null, 0);

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (5, 'LOG_LEVEL_ERROR', '1', 'ERROR log level flag: 1 - enabled, 0 - disabled');
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (6, 'LOG_LEVEL_WARNING', '0', 'WARNING log level flag: 1 - enabled, 0 - disabled');
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (7, 'LOG_LEVEL_INFO', '1', 'INFO log level flag: 1 - enabled, 0 - disabled');
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (8, 'LOG_LEVEL_DEBUG', '0', 'DEBUG log level flag: 1 - enabled, 0 - disabled');

--
-- REPORTS
--
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (9, 'DEFAULT_SENDER', 'default@sender.com', 'Default mail sender e-mail');
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (10, 'DEFAULT_MAILER', '', 'Default mailer (X-Mailer property)');
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (11, 'SMTP_SERVER', 'mail.queplix.com', 'SMTP host');
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (12, 'REPORT_ZIP_DIR', '/tmp/zip', 'Directory to make report ZIP in.');


insert into QX_FIELDINFO values ('qx_report_sched', 'period_unit', 14, 1, 'Minute');
insert into QX_FIELDINFO values ('qx_report_sched', 'period_unit', 14, 2, 'Hour');
insert into QX_FIELDINFO values ('qx_report_sched', 'period_unit', 14, 3, 'Day');
insert into QX_FIELDINFO values ('qx_report_sched', 'period_unit', 14, 4, 'Week');
insert into QX_FIELDINFO values ('qx_report_sched', 'period_unit', 14, 5, 'Month');
insert into QX_FIELDINFO values ('qx_report_sched', 'period_unit', 14, 6, 'Year');
insert into QX_FIELDINFO values ('qx_report_sched', 'period_unit', 14, 7, 'One time only');


--
-- TASKS
--

insert into QX_TASK_DELAYUNIT values (0, 'Minutes');
insert into QX_TASK_DELAYUNIT values (1, 'Hours');
insert into QX_TASK_DELAYUNIT values (2, 'Days');
insert into QX_TASK_DELAYUNIT values (3, 'Months');


insert into QX_TASK_STATUS values (0, 'NEW');
insert into QX_TASK_STATUS values (1, 'READY');
insert into QX_TASK_STATUS values (2, 'RUNNING');
insert into QX_TASK_STATUS values (3, 'WAITING');
insert into QX_TASK_STATUS values (4, 'COMPLETED');
insert into QX_TASK_STATUS values (5, 'INTERRUPTED');


/*
insert into QX_SCRIPT_PARAM_TYPES values (0, 'integer');
insert into QX_SCRIPT_PARAM_TYPES values (1, 'long');
insert into QX_SCRIPT_PARAM_TYPES values (2, 'float');
insert into QX_SCRIPT_PARAM_TYPES values (3, 'string');
*/


--
-- LOCKING
--

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (13, 'LockTimeout', '600', 'Max lock record timeout in seconds', 0);


--
-- STATES
--
INSERT INTO QX_STATES VALUES(1,'Alabama','AL')
INSERT INTO QX_STATES VALUES(2,'Alaska','AK')
INSERT INTO QX_STATES VALUES(3,'Arizona','AZ')
INSERT INTO QX_STATES VALUES(4,'Arkansas','AR')
INSERT INTO QX_STATES VALUES(5,'California','CA')
INSERT INTO QX_STATES VALUES(6,'Colorado','CO')
INSERT INTO QX_STATES VALUES(7,'Connecticut','CT')
INSERT INTO QX_STATES VALUES(8,'Delaware','DE')
INSERT INTO QX_STATES VALUES(9,'District Columbia','DC')
INSERT INTO QX_STATES VALUES(10,'Florida','FL')
INSERT INTO QX_STATES VALUES(11,'Georgia','GA')
INSERT INTO QX_STATES VALUES(12,'Hawaii','HI')
INSERT INTO QX_STATES VALUES(13,'Idaho','ID')
INSERT INTO QX_STATES VALUES(14,'Illinois','IL')
INSERT INTO QX_STATES VALUES(15,'Indiana','IN')
INSERT INTO QX_STATES VALUES(16,'Iowa','IA')
INSERT INTO QX_STATES VALUES(17,'Kansas','KS')
INSERT INTO QX_STATES VALUES(18,'Kentucky','KY')
INSERT INTO QX_STATES VALUES(19,'Louisiana','LA')
INSERT INTO QX_STATES VALUES(20,'Maine','ME')
INSERT INTO QX_STATES VALUES(21,'Maryland','MD')
INSERT INTO QX_STATES VALUES(22,'Massachusetts','MA')
INSERT INTO QX_STATES VALUES(23,'Michigan','MI')
INSERT INTO QX_STATES VALUES(24,'Minnesota','MN')
INSERT INTO QX_STATES VALUES(25,'Mississippi','MS')
INSERT INTO QX_STATES VALUES(26,'Missouri','MO')
INSERT INTO QX_STATES VALUES(27,'Montana','MT')
INSERT INTO QX_STATES VALUES(28,'Nebraska','NE')
INSERT INTO QX_STATES VALUES(29,'Nevada','NV')
INSERT INTO QX_STATES VALUES(30,'New Hampshire','NH')
INSERT INTO QX_STATES VALUES(31,'New Jersey','NJ')
INSERT INTO QX_STATES VALUES(32,'New Mexico','NM')
INSERT INTO QX_STATES VALUES(33,'New York','NY')
INSERT INTO QX_STATES VALUES(34,'North Carolina','NC')
INSERT INTO QX_STATES VALUES(35,'North Dakota','ND')
INSERT INTO QX_STATES VALUES(36,'Ohio','OH')
INSERT INTO QX_STATES VALUES(37,'Oklahoma','OK')
INSERT INTO QX_STATES VALUES(38,'Oregon','OR')
INSERT INTO QX_STATES VALUES(39,'Pennsylvania','PA')
INSERT INTO QX_STATES VALUES(40,'Rhode Island','RI')
INSERT INTO QX_STATES VALUES(41,'South Carolina','SC')
INSERT INTO QX_STATES VALUES(42,'South Dakota','SD')
INSERT INTO QX_STATES VALUES(43,'Tennessee','TN')
INSERT INTO QX_STATES VALUES(44,'Texas','TX')
INSERT INTO QX_STATES VALUES(45,'Utah','UT')
INSERT INTO QX_STATES VALUES(46,'Vermont','VT')
INSERT INTO QX_STATES VALUES(47,'Virginia','VA')
INSERT INTO QX_STATES VALUES(48,'Washington','WA')
INSERT INTO QX_STATES VALUES(49,'West Virginia','WV')
INSERT INTO QX_STATES VALUES(50,'Wisconsin','WI')
INSERT INTO QX_STATES VALUES(51,'Wyoming','WY')
go

INSERT INTO QX_MAIL_PROVIDER(PKEY, PROVIDER_ID, PROVIDER_NAME) VALUES(1, 'POP3', 'pop3')
INSERT INTO QX_MAIL_PROVIDER(PKEY, PROVIDER_ID, PROVIDER_NAME) VALUES(2, 'IMAP', 'imap')
go

--
-- SESSION TIMEOUT
--

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (14, 'SESSION_TIMEOUT', '720', 'User logon session timeout (in minutes)');
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (15, 'SESSION_TIMEOUT_WARN_BEFORE', '3', 'If the value is positive integer, a warning will be displayed the specified number of minutes before user logon session times out');

--
-- ACCOUNT
--

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (16, 'DEFAULT_EMAIL_PROVIDER', 'IMAP', 'Account default email provider', 1)
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (17, 'DEFAULT_EMAIL_SERVER', 'mail.queplix.com', 'Account default email server name', 1)
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (18, 'DEFAULT_EMAIL_PORT', '110', 'Account default server port', 1)
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (19, 'DEFAULT_EMAIL_FOLDER', 'Inbox', 'Account default email folder', 1)
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (21, 'CHECK_MAIL_TIMEOUT', '0', ''Email checker timeout'', 1)


--
-- INBOX
--

INSERT INTO QX_LOG_CLASS VALUES (1, 'Email Inbox', 'QX_EMAIL_SERVICE_LOG');
INSERT INTO QX_LOG_CLASS VALUES (2, 'Email Outbox', 'QX_EMAIL_SERVICE_LOG');
INSERT INTO QX_LOG_CLASS VALUES (3, 'Email Trash', 'QX_EMAIL_SERVICE_LOG');
INSERT INTO QX_LOG_CLASS VALUES (4, 'Email Autoreply', 'QX_EMAIL_SERVICE_LOG');
INSERT INTO QX_LOG_CLASS VALUES (5, 'Email Filter', 'QX_EMAIL_SERVICE_LOG');
INSERT INTO QX_LOG_CLASS VALUES (6, 'Email Routing', 'QX_EMAIL_SERVICE_LOG');
INSERT INTO QX_LOG_CLASS VALUES (7, 'Email Ticket', 'QX_EMAIL_SERVICE_LOG');
INSERT INTO QX_LOG_CLASS VALUES (8, 'Email System', 'QX_EMAIL_SERVICE_LOG');

--
-- VERSION
--

insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION) values (20, 'DB_CORE_VERSION', '076', 'Core database version. Do not modify');


commit;
