ALTER TABLE dbo.QX_CAPTION
    DROP CONSTRAINT FK_QX_CAPTION_QX_LANGUAGE
go
ALTER TABLE dbo.QX_NAT_FORMS
    DROP CONSTRAINT FK_QX_NAT_FORM_QX_LANGUAGE
go

drop table dbo.QX_COUNTRY
go

drop table dbo.QX_LANGUAGE
go

create table dbo.QX_LANGUAGE (
  PKEY          INT          NOT NULL,
  LANGUAGE_ID   CHAR(2)      NOT NULL,
  NAME          VARCHAR(255) NOT NULL,
constraint PK_QX_LANGUAGE primary key (LANGUAGE_ID)
)
go

insert into QX_LANGUAGE values (0, 'en', 'English');
insert into QX_LANGUAGE values (1, 'de', 'German');
insert into QX_LANGUAGE values (2, 'es', 'Spanish');
insert into QX_LANGUAGE values (3, 'fr', 'French');
insert into QX_LANGUAGE values (4, 'it', 'Italian');
insert into QX_LANGUAGE values (5, 'pt', 'Portuguese');
go

ALTER TABLE dbo.QX_NAT_FORMS
    ADD CONSTRAINT FK_QX_NAT_FORM_QX_LANGUAGE FOREIGN KEY(LANGUAGE_ID) REFERENCES dbo.QX_LANGUAGE (LANGUAGE_ID)
GO
ALTER TABLE dbo.QX_CAPTION
    ADD CONSTRAINT FK_QX_CAPTION_QX_LANGUAGE FOREIGN KEY(LANGUAGE_ID) REFERENCES dbo.QX_LANGUAGE (LANGUAGE_ID)
GO

drop table dbo.QX_TIMEZONE
go

create table dbo.QX_TIMEZONE (
  PKEY           INT          NOT NULL,
  TIMEZONE_ID    VARCHAR(255) NOT NULL,
  NAME           VARCHAR(255) NOT NULL,
  OFFSET         INT          NOT NULL,
constraint PK_QX_TIMEZONE primary key (PKEY)
)
go

insert into QX_TIMEZONE values (0, 'ACT', '(GMT+09:30) Central Standard Time (Northern Territory)',570);
insert into QX_TIMEZONE values (1, 'AET', '(GMT+10:00) Eastern Standard Time (New South Wales)',600);
insert into QX_TIMEZONE values (2, 'Africa/Abidjan', '(GMT-00:00) Greenwich Mean Time',0);
insert into QX_TIMEZONE values (3, 'Africa/Addis_Ababa', '(GMT+03:00) Eastern African Time',180);
insert into QX_TIMEZONE values (4, 'Africa/Algiers', '(GMT+01:00) Central European Time',60);
insert into QX_TIMEZONE values (5, 'Africa/Bangui', '(GMT+01:00) Western African Time',60);
insert into QX_TIMEZONE values (6, 'Africa/Blantyre', '(GMT+02:00) Central African Time',120);
insert into QX_TIMEZONE values (7, 'Africa/Casablanca', '(GMT-00:00) Western European Time',0);
insert into QX_TIMEZONE values (8, 'Africa/Johannesburg', '(GMT+02:00) South Africa Standard Time',120);
insert into QX_TIMEZONE values (9, 'AGT', '(GMT-03:00) Argentine Time',-180);
insert into QX_TIMEZONE values (10, 'America/Adak', '(GMT-10:00) Hawaii-Aleutian Standard Time',-600);
insert into QX_TIMEZONE values (11, 'America/Anguilla', '(GMT-04:00) Atlantic Standard Time',-240);
insert into QX_TIMEZONE values (12, 'America/Asuncion', '(GMT-04:00) Paraguay Time',-240);
insert into QX_TIMEZONE values (13, 'America/Belize', '(GMT-06:00) Central Standard Time',-360);
insert into QX_TIMEZONE values (14, 'America/Bogota', '(GMT-05:00) Colombia Time',-300);
insert into QX_TIMEZONE values (15, 'America/Caracas', '(GMT-04:00) Venezuela Time',-240);
insert into QX_TIMEZONE values (16, 'America/Cayenne', '(GMT-03:00) French Guiana Time',-180);
insert into QX_TIMEZONE values (17, 'America/Cayman', '(GMT-05:00) Eastern Standard Time',-300);
insert into QX_TIMEZONE values (18, 'America/Cuiaba', '(GMT-04:00) Amazon Standard Time',-240);
insert into QX_TIMEZONE values (19, 'America/Dawson_Creek', '(GMT-07:00) Mountain Standard Time',-420);
insert into QX_TIMEZONE values (20, 'America/Fortaleza', '(GMT-03:00) Brazil Time',-180);
insert into QX_TIMEZONE values (21, 'America/Godthab', '(GMT-03:00) Western Greenland Time',-180);
insert into QX_TIMEZONE values (22, 'America/Guayaquil', '(GMT-05:00) Ecuador Time',-300);
insert into QX_TIMEZONE values (23, 'America/Guyana', '(GMT-04:00) Guyana Time',-240);
insert into QX_TIMEZONE values (24, 'America/La_Paz', '(GMT-04:00) Bolivia Time',-240);
insert into QX_TIMEZONE values (25, 'America/Lima', '(GMT-05:00) Peru Time',-300);
insert into QX_TIMEZONE values (26, 'America/Los_Angeles', '(GMT-08:00) Pacific Standard Time',-480);
insert into QX_TIMEZONE values (27, 'America/Miquelon', '(GMT-03:00) Pierre & Miquelon Standard Time',-180);
insert into QX_TIMEZONE values (28, 'America/Montevideo', '(GMT-03:00) Uruguay Time',-180);
insert into QX_TIMEZONE values (29, 'America/Noronha', '(GMT-02:00) Fernando de Noronha Time',-120);
insert into QX_TIMEZONE values (30, 'America/Paramaribo', '(GMT-03:00) Suriname Time',-180);
insert into QX_TIMEZONE values (31, 'America/Porto_Acre', '(GMT-05:00) Acre Time',-300);
insert into QX_TIMEZONE values (32, 'America/Rio_Branco', '(GMT-05:00) GMT-05:00',-300);
insert into QX_TIMEZONE values (33, 'America/Santiago', '(GMT-04:00) Chile Time',-240);
insert into QX_TIMEZONE values (34, 'America/Scoresbysund', '(GMT-01:00) Eastern Greenland Time',-60);
insert into QX_TIMEZONE values (35, 'America/St_Johns', '(GMT-03:30) Newfoundland Standard Time',-210);
insert into QX_TIMEZONE values (36, 'Antarctica/Casey', '(GMT+08:00) Western Standard Time (Australia)',480);
insert into QX_TIMEZONE values (37, 'Antarctica/DumontDUrville', '(GMT+10:00) Dumont-d''Urville Time',600);
insert into QX_TIMEZONE values (38, 'Antarctica/Mawson', '(GMT+06:00) Mawson Time',360);
insert into QX_TIMEZONE values (39, 'Antarctica/McMurdo', '(GMT+12:00) New Zealand Standard Time',720);
insert into QX_TIMEZONE values (40, 'ART', '(GMT+02:00) Eastern European Time',120);
insert into QX_TIMEZONE values (41, 'Asia/Aden', '(GMT+03:00) Arabia Standard Time',180);
insert into QX_TIMEZONE values (42, 'Asia/Almaty', '(GMT+06:00) Alma-Ata Time',360);
insert into QX_TIMEZONE values (43, 'Asia/Anadyr', '(GMT+12:00) Anadyr Time',720);
insert into QX_TIMEZONE values (44, 'Asia/Aqtau', '(GMT+04:00) Aqtau Time',240);
insert into QX_TIMEZONE values (45, 'Asia/Aqtobe', '(GMT+05:00) Aqtobe Time',300);
insert into QX_TIMEZONE values (46, 'Asia/Ashgabat', '(GMT+05:00) Turkmenistan Time',300);
insert into QX_TIMEZONE values (47, 'Asia/Baku', '(GMT+04:00) Azerbaijan Time',240);
insert into QX_TIMEZONE values (48, 'Asia/Bangkok', '(GMT+07:00) Indochina Time',420);
insert into QX_TIMEZONE values (49, 'Asia/Bishkek', '(GMT+05:00) Kirgizstan Time',300);
insert into QX_TIMEZONE values (50, 'Asia/Brunei', '(GMT+08:00) Brunei Time',480);
insert into QX_TIMEZONE values (51, 'Asia/Calcutta', '(GMT+05:30) India Standard Time',330);
insert into QX_TIMEZONE values (52, 'Asia/Colombo', '(GMT+06:00) Sri Lanka Time',360);
insert into QX_TIMEZONE values (53, 'Asia/Dacca', '(GMT+06:00) Bangladesh Time',360);
insert into QX_TIMEZONE values (54, 'Asia/Dubai', '(GMT+04:00) Gulf Standard Time',240);
insert into QX_TIMEZONE values (55, 'Asia/Dushanbe', '(GMT+05:00) Tajikistan Time',300);
insert into QX_TIMEZONE values (56, 'Asia/Hong_Kong', '(GMT+08:00) Hong Kong Time',480);
insert into QX_TIMEZONE values (57, 'Asia/Irkutsk', '(GMT+08:00) Irkutsk Time',480);
insert into QX_TIMEZONE values (58, 'Asia/Jakarta', '(GMT+07:00) Java Time',420);
insert into QX_TIMEZONE values (59, 'Asia/Jayapura', '(GMT+09:00) Jayapura Time',540);
insert into QX_TIMEZONE values (60, 'Asia/Jerusalem', '(GMT+02:00) Israel Standard Time',120);
insert into QX_TIMEZONE values (61, 'Asia/Kabul', '(GMT+04:30) Afghanistan Time',270);
insert into QX_TIMEZONE values (62, 'Asia/Kamchatka', '(GMT+12:00) Petropavlovsk-Kamchatski Time',720);
insert into QX_TIMEZONE values (63, 'Asia/Karachi', '(GMT+05:00) Pakistan Time',300);
insert into QX_TIMEZONE values (64, 'Asia/Katmandu', '(GMT+05:45) Nepal Time',345);
insert into QX_TIMEZONE values (65, 'Asia/Krasnoyarsk', '(GMT+07:00) Krasnoyarsk Time',420);
insert into QX_TIMEZONE values (66, 'Asia/Kuala_Lumpur', '(GMT+08:00) Malaysia Time',480);
insert into QX_TIMEZONE values (67, 'Asia/Macao', '(GMT+08:00) China Standard Time',480);
insert into QX_TIMEZONE values (68, 'Asia/Magadan', '(GMT+11:00) Magadan Time',660);
insert into QX_TIMEZONE values (69, 'Asia/Manila', '(GMT+08:00) Philippines Time',480);
insert into QX_TIMEZONE values (70, 'Asia/Novosibirsk', '(GMT+06:00) Novosibirsk Time',360);
insert into QX_TIMEZONE values (71, 'Asia/Pyongyang', '(GMT+09:00) Korea Standard Time',540);
insert into QX_TIMEZONE values (72, 'Asia/Rangoon', '(GMT+06:30) Myanmar Time',390);
insert into QX_TIMEZONE values (73, 'Asia/Singapore', '(GMT+08:00) Singapore Time',480);
insert into QX_TIMEZONE values (74, 'Asia/Tashkent', '(GMT+05:00) Uzbekistan Time',300);
insert into QX_TIMEZONE values (75, 'Asia/Tbilisi', '(GMT+04:00) Georgia Time',240);
insert into QX_TIMEZONE values (76, 'Asia/Tehran', '(GMT+03:30) Iran Time',210);
insert into QX_TIMEZONE values (77, 'Asia/Thimbu', '(GMT+06:00) Bhutan Time',360);
insert into QX_TIMEZONE values (78, 'Asia/Tokyo', '(GMT+09:00) Japan Standard Time',540);
insert into QX_TIMEZONE values (79, 'Asia/Ujung_Pandang', '(GMT+08:00) Borneo Time',480);
insert into QX_TIMEZONE values (80, 'Asia/Ulaanbaatar', '(GMT+08:00) Ulaanbaatar Time',480);
insert into QX_TIMEZONE values (81, 'Asia/Vladivostok', '(GMT+10:00) Vladivostok Time',600);
insert into QX_TIMEZONE values (82, 'Asia/Yakutsk', '(GMT+09:00) Yakutsk Time',540);
insert into QX_TIMEZONE values (83, 'Asia/Yekaterinburg', '(GMT+05:00) Yekaterinburg Time',300);
insert into QX_TIMEZONE values (84, 'Asia/Yerevan', '(GMT+04:00) Armenia Time',240);
insert into QX_TIMEZONE values (85, 'AST', '(GMT-09:00) Alaska Standard Time',-540);
insert into QX_TIMEZONE values (86, 'Atlantic/Azores', '(GMT-01:00) Azores Time',-60);
insert into QX_TIMEZONE values (87, 'Atlantic/Cape_Verde', '(GMT-01:00) Cape Verde Time',-60);
insert into QX_TIMEZONE values (88, 'Atlantic/South_Georgia', '(GMT-02:00) South Georgia Standard Time',-120);
insert into QX_TIMEZONE values (89, 'Atlantic/Stanley', '(GMT-04:00) Falkland Is. Time',-240);
insert into QX_TIMEZONE values (90, 'Australia/Adelaide', '(GMT+09:30) Central Standard Time (South Australia)',570);
insert into QX_TIMEZONE values (91, 'Australia/Brisbane', '(GMT+10:00) Eastern Standard Time (Queensland)',600);
insert into QX_TIMEZONE values (92, 'Australia/Broken_Hill', '(GMT+09:30) Central Standard Time (South Australia/New South Wales)',570);
insert into QX_TIMEZONE values (93, 'Australia/Hobart', '(GMT+10:00) Eastern Standard Time (Tasmania)',600);
insert into QX_TIMEZONE values (94, 'Australia/Lord_Howe', '(GMT+10:30) Load Howe Standard Time',630);
insert into QX_TIMEZONE values (95, 'Europe/Moscow', '(GMT+03:00) Moscow Standard Time',180);
insert into QX_TIMEZONE values (96, 'Europe/Samara', '(GMT+04:00) Samara Time',240);
insert into QX_TIMEZONE values (97, 'HST', '(GMT-10:00) Hawaii Standard Time',-600);
insert into QX_TIMEZONE values (98, 'Indian/Chagos', '(GMT+05:00) Indian Ocean Territory Time',300);
insert into QX_TIMEZONE values (99, 'Indian/Christmas', '(GMT+07:00) Christmas Island Time',420);
insert into QX_TIMEZONE values (100, 'Indian/Cocos', '(GMT+06:30) Cocos Islands Time',390);
insert into QX_TIMEZONE values (101, 'Indian/Kerguelen', '(GMT+05:00) French Southern & Antarctic Lands Time',300);
insert into QX_TIMEZONE values (102, 'Indian/Mahe', '(GMT+04:00) Seychelles Time',240);
insert into QX_TIMEZONE values (103, 'Indian/Maldives', '(GMT+05:00) Maldives Time',300);
insert into QX_TIMEZONE values (104, 'Indian/Mauritius', '(GMT+04:00) Mauritius Time',240);
insert into QX_TIMEZONE values (105, 'Indian/Reunion', '(GMT+04:00) Reunion Time',240);
insert into QX_TIMEZONE values (106, 'MIT', '(GMT-11:00) West Samoa Time',-660);
insert into QX_TIMEZONE values (107, 'Pacific/Chatham', '(GMT+12:45) Chatham Standard Time',765);
insert into QX_TIMEZONE values (108, 'Pacific/Easter', '(GMT-06:00) Easter Is. Time',-360);
insert into QX_TIMEZONE values (109, 'Pacific/Efate', '(GMT+11:00) Vanuatu Time',660);
insert into QX_TIMEZONE values (110, 'Pacific/Enderbury', '(GMT+13:00) Phoenix Is. Time',780);
insert into QX_TIMEZONE values (111, 'Pacific/Fakaofo', '(GMT-10:00) Tokelau Time',-600);
insert into QX_TIMEZONE values (112, 'Pacific/Fiji', '(GMT+12:00) Fiji Time',720);
insert into QX_TIMEZONE values (113, 'Pacific/Funafuti', '(GMT+12:00) Tuvalu Time',720);
insert into QX_TIMEZONE values (114, 'Pacific/Galapagos', '(GMT-06:00) Galapagos Time',-360);
insert into QX_TIMEZONE values (115, 'Pacific/Gambier', '(GMT-09:00) Gambier Time',-540);
insert into QX_TIMEZONE values (116, 'Pacific/Guadalcanal', '(GMT+11:00) Solomon Is. Time',660);
insert into QX_TIMEZONE values (117, 'Pacific/Guam', '(GMT+10:00) Chamorro Standard Time',600);
insert into QX_TIMEZONE values (118, 'Pacific/Kiritimati', '(GMT+14:00) Line Is. Time',840);
insert into QX_TIMEZONE values (119, 'Pacific/Kosrae', '(GMT+11:00) Kosrae Time',660);
insert into QX_TIMEZONE values (120, 'Pacific/Majuro', '(GMT+12:00) Marshall Islands Time',720);
insert into QX_TIMEZONE values (121, 'Pacific/Marquesas', '(GMT-09:30) Marquesas Time',-570);
insert into QX_TIMEZONE values (122, 'Pacific/Nauru', '(GMT+12:00) Nauru Time',720);
insert into QX_TIMEZONE values (123, 'Pacific/Niue', '(GMT-11:00) Niue Time',-660);
insert into QX_TIMEZONE values (124, 'Pacific/Norfolk', '(GMT+11:30) Norfolk Time',690);
insert into QX_TIMEZONE values (125, 'Pacific/Noumea', '(GMT+11:00) New Caledonia Time',660);
insert into QX_TIMEZONE values (126, 'Pacific/Pago_Pago', '(GMT-11:00) Samoa Standard Time',-660);
insert into QX_TIMEZONE values (127, 'Pacific/Palau', '(GMT+09:00) Palau Time',540);
insert into QX_TIMEZONE values (128, 'Pacific/Pitcairn', '(GMT-08:00) Pitcairn Standard Time',-480);
insert into QX_TIMEZONE values (129, 'Pacific/Ponape', '(GMT+11:00) Ponape Time',660);
insert into QX_TIMEZONE values (130, 'Pacific/Port_Moresby', '(GMT+10:00) Papua New Guinea Time',600);
insert into QX_TIMEZONE values (131, 'Pacific/Rarotonga', '(GMT-10:00) Cook Is. Time',-600);
insert into QX_TIMEZONE values (132, 'Pacific/Tahiti', '(GMT-10:00) Tahiti Time',-600);
insert into QX_TIMEZONE values (133, 'Pacific/Tarawa', '(GMT+12:00) Gilbert Is. Time',720);
insert into QX_TIMEZONE values (134, 'Pacific/Tongatapu', '(GMT+13:00) Tonga Time',780);
insert into QX_TIMEZONE values (135, 'Pacific/Truk', '(GMT+10:00) Truk Time',600);
insert into QX_TIMEZONE values (136, 'Pacific/Wake', '(GMT+12:00) Wake Time',720);
insert into QX_TIMEZONE values (137, 'Pacific/Wallis', '(GMT+12:00) Wallis & Futuna Time',720);
insert into QX_TIMEZONE values (138, 'UTC', '(GMT-00:00) Coordinated Universal Time',0);
go

create table dbo.QX_COUNTRY (
  PKEY                 INT          NOT NULL,
  COUNTRY_ID           VARCHAR(3)   NOT NULL,
  NAME                 VARCHAR(255) NOT NULL,
  DEF_LANG_ID          CHAR(2),
  DEF_TIMEZONE_ID      VARCHAR(255),
constraint PK_QX_COUNTRY primary key (PKEY),
--constraint FK_QX_COUNTRY_QX_LANGUAGE    foreign key (DEF_LANG_ID)    references QX_LANGUAGE (LANGUAGE_ID),
--constraint FK_QX_COUNTTRY_QX_TIMEZONE    foreign key (DEF_TIMEZONE_ID)    references QX_TIMEZONE (TIMEZONE_ID)
)
go

create index IDX_QX_COUNTRY_LANGUAGE on dbo.QX_COUNTRY (DEF_LANG_ID)
create index IDX_QX_COUNTRY_TIMEZONE on dbo.QX_COUNTRY (DEF_TIMEZONE_ID)
go

insert into QX_COUNTRY values (0, 'US', 'United States', 'en', 'America/Belize');
insert into QX_COUNTRY values (1, 'DE', 'Germany', 'de', 'Africa/Algiers');
insert into QX_COUNTRY values (2, 'FR', 'France', 'de', 'Africa/Algiers');
insert into QX_COUNTRY values (3, 'IT', 'Italy', 'it', 'Africa/Algiers');
insert into QX_COUNTRY values (4, 'ES', 'Spain', 'es', 'UTC');
insert into QX_COUNTRY values (5, 'PT', 'Portugal', 'pt', 'UTC');
insert into QX_COUNTRY values (6, 'GB', 'United Kingdom', 'en', 'UTC');
insert into QX_COUNTRY values (7, 'IE', 'Ireland', 'en', 'UTC');
go

CREATE TABLE dbo.QX_TIME_PATTERN (
  PKEY             INT          NOT NULL,
  TIME_PATTERN_ID  VARCHAR(255) NOT NULL
constraint PK_QX_TIME_PATTERN primary key (PKEY),
)
GO

INSERT INTO dbo.QX_TIME_PATTERN VALUES (0, 'H:mm');
INSERT INTO dbo.QX_TIME_PATTERN VALUES (1, 'h:mm a');
INSERT INTO dbo.QX_TIME_PATTERN VALUES (2, 'HH:mm:ss');
GO

CREATE TABLE dbo.QX_DATE_PATTERN (
  PKEY             INT          NOT NULL,
  DATE_PATTERN_ID  VARCHAR(255) NOT NULL
constraint PK_QX_DATE_PATTERN primary key (PKEY),
)
GO

INSERT INTO dbo.QX_DATE_PATTERN VALUES (0, 'd MMM y');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (1, 'd MMM yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (2, 'dd MMM yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (3, 'dd MMM yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (4, 'dd/MM/yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (5, 'ddMMMyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (6, 'ddMMMyyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (7, 'dMMMyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (8, 'M/d/yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (9, 'M/d/yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (10, 'MM/dd/yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (11, 'MM/dd/yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (12, 'MMddyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (13, 'MMddyyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (14, 'MMM d, yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (15, 'MMMM d yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (16, 'MMMM d yyyy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (17, 'MMMM dd yy');
INSERT INTO dbo.QX_DATE_PATTERN VALUES (18, 'MMMM dd yyyy');
GO

drop view dbo.QX_DD_DATEPOS
go
create view dbo.QX_DD_DATEPOS as
    select
        ENUM_VALUE as PKEY,
        ENUM_LABEL as NAME
    from QX_FIELDINFO
    where (TABLE_NAME = 'qx_user_settings') and (COLUMN_NAME = 'date_position')
go

delete from QX_FIELDINFO where TABLE_NAME = 'qx_user_prop'
go
insert into QX_FIELDINFO values ('qx_user_settings', 'date_position', 14, 0, 'First');
insert into QX_FIELDINFO values ('qx_user_settings', 'date_position', 14, 1, 'Second');
go

drop table dbo.QX_USER_SETTINGS
go

create table dbo.QX_USER_SETTINGS (
  PKEY        INT  NOT NULL,
  USER_ID     INT  NOT NULL,
  LANG        INT  NULL,
  COUNTRY     INT  NULL,
  TIMEZONE    INT  NULL,
  DPATTERN    INT  NULL,
  TPATTERN    INT  NULL,
  DPOS        INT  NULL,
constraint PK_USER_SETTINGS primary key (PKEY)
)
go

create unique index IDX_USER_SETTINGS_USER_ID on dbo.QX_USER_SETTINGS (USER_ID)
go


UPDATE QX_SYS_PROP SET PROP_VAL = '023' WHERE (PROP_ID = 'DB_CORE_VERSION');
go
