ALTER TABLE QX_USER_PROP
ALTER COLUMN PROP_ID VARCHAR(512) NOT NULL
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[qx_user_permissions]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[qx_user_permissions]
GO

create view dbo.qx_user_permissions as
    select u.pkey as user_id, p.*, vo.name as object_name
    from qx_permission p
		inner join qx_role_to_users r2u on p.role_id = r2u.role_id
		inner join qx_users u on u.pkey = r2u.user_id
		inner join qx_view_objects vo on p.object_id = vo.pkey
    union
    select u.pkey as user_id, p.*, vo.name as object_name
    from qx_permission p
		inner join qx_workgroup_to_role w2r on p.role_id = w2r.role_id
		inner join qx_workgroup w on w.pkey = w2r.workgroup_id
		inner join qx_groupmember gm on gm.workgroupgroup = w.pkey
		inner join qx_users u on u.pkey = gm.employeegroup
		inner join qx_view_objects vo on p.object_id = vo.pkey
go


UPDATE QX_SYS_PROP SET PROP_VAL = '027' WHERE (PROP_ID = 'DB_CORE_VERSION');
GO