-- remove captions tables
if exists (select * from dbo.sysobjects where id = object_id(N'[QX_CAPTION]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [QX_CAPTION]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[QX_CAP_TYPE]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [QX_CAP_TYPE]
GO


-- add localization tables
if exists (select * from dbo.sysobjects where id = object_id(N'[QX_LOCALIZATION]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [QX_LOCALIZATION]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[QX_LOCALIZATION_TYPE]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [QX_LOCALIZATION_TYPE]
GO
if exists (select * from dbo.sysobjects where id = object_id(N'[QX_LOCALIZED_OBJECT_TYPE]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [QX_LOCALIZED_OBJECT_TYPE]
GO

create table dbo.QX_LOCALIZATION_TYPE (
  LOCALIZATION_TYPE_ID   INT             NOT NULL,
  NAME                   VARCHAR(255)    NOT NULL,
constraint PK_QX_LOCALIZATION_TYPE primary key (LOCALIZATION_TYPE_ID)
)
go
insert into dbo.QX_LOCALIZATION_TYPE values (0, 'Captions');
insert into dbo.QX_LOCALIZATION_TYPE values (1, 'Descriptions');
go

create table dbo.QX_LOCALIZED_OBJECT_TYPE (
  OBJECT_TYPE_ID  INT               NOT NULL,
  NAME            VARCHAR(255)      NOT NULL,
constraint PK_QX_LOCALIZED_OBJECT_TYPE primary key (OBJECT_TYPE_ID)
)
go
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (0, 'Label');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (1, 'Focus');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (2, 'Tab');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (3, 'Form');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (4, 'Server Side Message');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (5, 'Client Side Message');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (6, 'Popup Menu');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (7, 'Sub Focus');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (8, 'Context Menu');
insert into dbo.QX_LOCALIZED_OBJECT_TYPE values (9, 'Form Button')
go

create table dbo.QX_LOCALIZATION (
  LOCALIZATION_ID	    VARCHAR(255)      NOT NULL,
  LOCALIZATION_TYPE_ID  INT               NOT NULL,
  OBJECT_TYPE_ID	    INT               NOT NULL,
  LANGUAGE_ID		    CHAR(2)           NOT NULL,
  CONTENT               NVARCHAR(4000)    NOT NULL,
constraint PK_QX_LOCALIZATION primary key (LOCALIZATION_ID, LOCALIZATION_TYPE_ID, LANGUAGE_ID, OBJECT_TYPE_ID),
constraint FK_QX_LOCALIZATION_QX_LANGUAGE foreign key (LANGUAGE_ID) references QX_LANGUAGE (LANGUAGE_ID),
constraint FK_QX_LOCALIZATION_QX_LOCALIZATION_TYPE foreign key (LOCALIZATION_TYPE_ID) references QX_LOCALIZATION_TYPE (LOCALIZATION_TYPE_ID),
constraint FK_QX_LOCALIZATION_QX_LOCALIZED_OBJECT_TYPE foreign key (OBJECT_TYPE_ID) references QX_LOCALIZED_OBJECT_TYPE (OBJECT_TYPE_ID)
)
go

create index IDX_QX_LOCALIZATION_LANGUAGE on dbo.QX_LOCALIZATION (LANGUAGE_ID)
-- [MVT] WARNING! Don't try to create index on the
--                LOCALIZATION_TYPE_ID column - appication hangs
--create index IDX_QX_LOCALIZATION_TYPE on dbo.QX_LOCALIZATION (LOCALIZATION_TYPE_ID)
create index IDX_QX_LOCALIZATION_OBJECT on dbo.QX_LOCALIZATION (OBJECT_TYPE_ID)
go

UPDATE QX_SYS_PROP SET PROP_VAL = '031' WHERE (PROP_ID = 'DB_CORE_VERSION');
go