create table dbo.QX_INBOX (
    PKEY int not null,
    MESSAGE_TYPE int not null default 0, -- 0 is email message, 1 - alert
    MESSAGE_SENDER int null,
    MESSAGE_SENDER_EMAIL varchar(1024),
    RECIPIENT_ID int null,
    WORKGROUP_ID int null,
    EMAIL_TO varchar(1024) null,
    EMAIL_CC varchar(1024) null,
    SUBJECT varchar(1024) null,
    MESSAGE text,
    SENT_DATE datetime,
    SERVER_RECEIVED_DATE datetime,
    RECEIVED_DATE datetime,
    OBJECT_TYPE int null,
    OBJECT_ID int null,
    REPLIED_DATE datetime,
    PROCESS_ID int null,
    ACCOUNT_ID int null,
    DIGEST_SRC varchar(512),
    DELETE_FLAG int not null default 0, -- 0 existed, 1 - deleted

    constraint PK_QX_INBOX primary key (PKEY),
    constraint FK_QX_INBOX_SENDER_QX_USERS foreign key (MESSAGE_SENDER) references QX_USERS(PKEY),
    constraint FK_QX_INBOX_RECIPIENT_QX_USERS foreign key (RECIPIENT_ID) references QX_USERS(PKEY),
    constraint FK_QX_INBOX_WORKGROUP_QX_WORKGROUP foreign key (WORKGROUP_ID) references QX_WORKGROUP(PKEY),
    constraint FK_QX_INBOX_OBJECT_TYPE_QX_VIEW_OBJECT_TYPES foreign key (OBJECT_TYPE) references QX_VIEW_OBJECT_TYPES(PKEY),
    constraint FK_QX_INBOX_ACCOUNT_ID_QX_ACCOUNT foreign key (ACCOUNT_ID) references QX_ACCOUNT(PKEY),
)
go

delete from QX_EMAIL_ROUTING
go
delete from QX_FILTER_ACCOUNT
go
delete from QX_ACCOUNT
go
delete from QX_MAIL_PROVIDER
go

DECLARE @id int
EXEC dbo.QX_NEXT_KEY 'qx_mail_provider', 1, @id OUTPUT
INSERT INTO QX_MAIL_PROVIDER VALUES (@id, 'pop3', 'POP3')
EXEC dbo.QX_NEXT_KEY 'qx_mail_provider', 1, @id OUTPUT
INSERT INTO QX_MAIL_PROVIDER VALUES (@id, 'imap', 'IMAP')
go

UPDATE QX_SYS_PROP SET PROP_VAL = '033' WHERE (PROP_ID = 'DB_CORE_VERSION');
go
