-- QX_FILTER_ACCOUNT --

CREATE TABLE dbo.TMP_FILTER_ACCOUNT(
	ACCOUNT_ID int NULL,
	EMAIL_FILTER int NULL
)
go

ALTER TABLE dbo.QX_FILTER_ACCOUNT DROP CONSTRAINT PK_QX_FILTER_ACCOUNT
go

INSERT INTO dbo.TMP_FILTER_ACCOUNT
select * from dbo.QX_FILTER_ACCOUNT
go

TRUNCATE TABLE dbo.QX_FILTER_ACCOUNT
go

ALTER TABLE dbo.QX_FILTER_ACCOUNT
ADD PKEY int NULL
go

ALTER TABLE dbo.QX_FILTER_ACCOUNT
ALTER COLUMN PKEY int NOT NULL
go

ALTER TABLE dbo.QX_FILTER_ACCOUNT
ADD CONSTRAINT PK_QX_FILTER_ACCOUNT PRIMARY KEY CLUSTERED (PKEY)
go

DECLARE @accnt int
DECLARE @filter int
DECLARE @id int

DECLARE cur CURSOR FOR
  SELECT ACCOUNT_ID, EMAIL_FILTER 
    FROM dbo.TMP_FILTER_ACCOUNT

  OPEN cur

  FETCH NEXT FROM cur INTO @accnt, @filter
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
      EXEC dbo.QX_NEXT_KEY 'qx_filter_account', 1, @id OUTPUT
      INSERT INTO dbo.QX_FILTER_ACCOUNT (PKEY, ACCOUNT_ID, EMAIL_FILTER)
        VALUES(@id, @accnt, @filter)

      FETCH NEXT FROM cur INTO @accnt, @filter
    END
  CLOSE cur
  DEALLOCATE cur
GO

DROP TABLE dbo.TMP_FILTER_ACCOUNT
GO


-- QX_EMAIL_ROUTING --

CREATE TABLE dbo.TMP_EMAIL_ROUTING(
	ACCOUNT_ID int NULL,
	ROUTING_RULE int NULL
)
go

ALTER TABLE dbo.QX_EMAIL_ROUTING DROP CONSTRAINT PK_QX_EMAIL_ROUTING
go

INSERT INTO dbo.TMP_EMAIL_ROUTING
select * from dbo.QX_EMAIL_ROUTING
go

TRUNCATE TABLE dbo.QX_EMAIL_ROUTING
go

ALTER TABLE dbo.QX_EMAIL_ROUTING
ADD PKEY int NULL
go

ALTER TABLE dbo.QX_EMAIL_ROUTING
ALTER COLUMN PKEY int NOT NULL
go

ALTER TABLE dbo.QX_EMAIL_ROUTING
ADD CONSTRAINT PK_QX_EMAIL_ROUTING PRIMARY KEY CLUSTERED (PKEY)
go

DECLARE @accnt int
DECLARE @rule int
DECLARE @id int

DECLARE cur CURSOR FOR
  SELECT ACCOUNT_ID, ROUTING_RULE 
    FROM dbo.TMP_EMAIL_ROUTING

  OPEN cur

  FETCH NEXT FROM cur INTO @accnt, @rule
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
      EXEC dbo.QX_NEXT_KEY 'qx_email_routing', 1, @id OUTPUT
      INSERT INTO dbo.QX_EMAIL_ROUTING (PKEY, ACCOUNT_ID, ROUTING_RULE)
        VALUES(@id, @accnt, @rule)

      FETCH NEXT FROM cur INTO @accnt, @rule
    END
  CLOSE cur
  DEALLOCATE cur
GO

DROP TABLE dbo.TMP_EMAIL_ROUTING
GO


-- QX_HIS_TBLFIELD --

CREATE TABLE dbo.TMP_HIS_TBLFIELD(
	HIS_TABLE_ID int NULL,
	HIS_FIELD_ID int NULL,
)
go

ALTER TABLE dbo.QX_HIS_TBLFIELD DROP CONSTRAINT PK_QX_HIS_TBLFIELD
go

INSERT INTO dbo.TMP_HIS_TBLFIELD
select * from dbo.QX_HIS_TBLFIELD
go

TRUNCATE TABLE dbo.QX_HIS_TBLFIELD
go

ALTER TABLE dbo.QX_HIS_TBLFIELD
ADD PKEY int NULL
go

ALTER TABLE dbo.QX_HIS_TBLFIELD
ALTER COLUMN PKEY int NOT NULL
go

ALTER TABLE dbo.QX_HIS_TBLFIELD
ADD CONSTRAINT PK_QX_HIS_TBLFIELD PRIMARY KEY CLUSTERED (PKEY)
go

DECLARE @tbl int
DECLARE @fld int
DECLARE @id int

DECLARE cur CURSOR FOR
  SELECT HIS_TABLE_ID, HIS_FIELD_ID 
    FROM dbo.TMP_HIS_TBLFIELD

  OPEN cur

  FETCH NEXT FROM cur INTO @tbl, @fld
    WHILE (@@FETCH_STATUS = 0)
    BEGIN
      EXEC dbo.QX_NEXT_KEY 'qx_his_tblfield', 1, @id OUTPUT
      INSERT INTO dbo.QX_HIS_TBLFIELD (PKEY, HIS_TABLE_ID, HIS_FIELD_ID)
        VALUES(@id, @tbl, @fld)

      FETCH NEXT FROM cur INTO @tbl, @fld
    END
  CLOSE cur
  DEALLOCATE cur
GO

DROP TABLE dbo.TMP_HIS_TBLFIELD
GO


UPDATE QX_SYS_PROP SET PROP_VAL = '072' WHERE (PROP_ID = 'DB_CORE_VERSION');
go



