DECLARE @form_id varchar(255), @formset_id int, @focus_name varchar(255), @new_name varchar(255), @devider_pos int

print('Start form id renaming.');

DECLARE rename_cursor CURSOR FOR
SELECT formset_id, form_id
FROM qx_formset

OPEN rename_cursor

FETCH NEXT FROM rename_cursor
INTO @formset_id, @form_id

WHILE @@FETCH_STATUS = 0
BEGIN
      
    set @devider_pos = charindex('__', @form_id) - 1;
    set @focus_name = left(@form_id, @devider_pos);
    set @new_name = @focus_name + '__' + @form_id;
        
    print('Form: ' + @form_id + ', renamed to :' + @new_name);
    update qx_formset set form_id = @new_name where formset_id = @formset_id
      
	FETCH NEXT FROM rename_cursor
	INTO @formset_id, @form_id
END

CLOSE rename_cursor
DEALLOCATE rename_cursor
GO
