/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

/**
 * @author aliaksandr.melnik
 */
package com.queplix.core.client.app.vo;

import java.util.ArrayList;
import java.util.List;

/**
 * Data of the Ad hoc Report grid search records request.
 *
 * @author Melnik Alexander
 */
public class AdhocSearchGridRecordsRequest extends BaseFilteredGridRequest {

    private List/*]<AdhocReportElement>[*/ fields;

    public AdhocSearchGridRecordsRequest(List/*]<EntityData>[*/ entitiyFilters,
                                         List/*]<AdhocReportElement>[*/ fields,
                                         GridSearchProperties props) {
        super(props, entitiyFilters);
        setFields(fields);
    }

    public AdhocSearchGridRecordsRequest() {
        this(null, null, null);
    }

    public List/*]<AdhocReportElement>[*/ getFields() {
        return fields;
    }

    public void setFields(List/*]<AdhocReportElement>[*/ fields) {
        if(fields == null) {
            this.fields = new ArrayList();
        } else {
            this.fields = fields;
        }
    }

}
