/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

/**
 * Base class for field data. This implements logic by storing field id.
 *
 * @author Sergey Kozmin
 * @since 13.10.2006, 15:14:49
 */
public abstract class BaseFieldData implements FieldData {
    private String fieldID;

    public BaseFieldData(String fieldID) {
        this.setFieldID(fieldID);
    }

    public BaseFieldData() {
    }

    public String getFieldID() {
        return fieldID;
    }

    public void setFieldID(String fieldID) {
        this.fieldID = fieldID;
    }
}
