/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Base implementation of the request interface.
 *
 * @author Sergey Kozmin
 * @since 08.11.2006, 18:39:03
 */
public abstract class BaseFieldDataRequest implements FieldDataRequest {
    private int theType = -1;
    private String elementID = "";
	private List/*<EntityData>*/ filters = new ArrayList();


    protected BaseFieldDataRequest(int theType, String elementID) {
        this.theType = theType;
        this.elementID = elementID;
    }

    public BaseFieldDataRequest() {
        this(-1, "");
    }

    public int getRequestType() {
        return theType;
    }

    public String getElementID() {
        return elementID;
    }

    public void setElementID(String elementID) {
        this.elementID = elementID;
    }
    
   public EntityData[] getFilters() {
		EntityData[] result = new EntityData[filters.size()];
		int i = 0;
		for (Iterator it = filters.iterator(); it.hasNext();) {
			result[i++] = (EntityData) it.next();
		}
		return result;
   }

    public void addFilter(EntityData filter) {
		filters.add(filter);
    }

}
