/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

/**
 * Base List Field Data.
 *
 * @author Alexander Epifanov
 * @since 21 Nov 2006
 */
public abstract class BaseListFieldData extends BaseFieldData {
    private SubsetData itemsSelected;
    private SubsetMeta availableChoises; // used when the control is dynamic

    public BaseListFieldData(String fieldID, SubsetData itemsSelected) {
        super(fieldID);
        setItemsSelected(itemsSelected);
    }

    public BaseListFieldData(String fieldID) {
        super(fieldID);
    }

    public BaseListFieldData() {
        this("");
    }

    public void clear() {
        itemsSelected.setSelectedIDs(new long[0]);
    }

    public abstract FieldData cloneData();

    public SubsetData getItemsSelected() {
        return itemsSelected;
    }

    public boolean isEmpty() {
        return !(0 < itemsSelected.getSelectedIDs().length);
    }

    public void setItemsSelected(SubsetData itemsSelected) {
        if(itemsSelected != null) {
            this.itemsSelected = itemsSelected;
        } else {
            this.itemsSelected = new SubsetData();
        }
    }

    /**
     * Used when the control is dynamic, otherwise -- null
     */
    public SubsetMeta getAvailableChoises() {
        return availableChoises;
    }

    /**
     * Should be used when the control is dynamic only, otherwise -- null
     */
    public void setAvailableChoises(SubsetMeta availableChoises) {
        this.availableChoises = availableChoises;
    }

    public boolean dataEqualsTo(FieldData data) {
        boolean ret = false;
        if(data != null && data.getFieldID().equalsIgnoreCase(getFieldID())) {
            //assume that if ids are equal, then control types are equal too (within one form)
            BaseListFieldData castData = (BaseListFieldData) data;

            boolean availableChoisesEqual;
            if(castData.availableChoises != null) {
                availableChoisesEqual = castData.availableChoises
                        .equalsToMeta(availableChoises);
            } else {
                availableChoisesEqual = availableChoises == null;
            }

            ret = availableChoisesEqual
                    && castData.itemsSelected.equalsToData(itemsSelected);
        }
        return ret;
    }
}
