/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

/**
 * Base List Field Meta.
 *
 * @author Alexander Epifanov
 * @since 21 Nov 2006
 */
public class BaseListFieldMeta extends BaseFieldMeta {
    private SubsetMeta availableChoises;
    private String referencingEntityName;
    private boolean dynamic;

    public BaseListFieldMeta(int fieldType, String fieldID, String caption,
                             boolean required, boolean descriptive,
                             boolean readOnly,
                             boolean searchable, boolean hasDefSrcAttribute,
                             String referencingEntityName,
                             SubsetMeta availableChoises, boolean dynamic) {
        super(fieldType, fieldID, caption, required, descriptive, readOnly,
                searchable, hasDefSrcAttribute);
        this.referencingEntityName = referencingEntityName;
        this.dynamic = dynamic;
        this.availableChoises = availableChoises;
    }

    public BaseListFieldMeta(int fieldType, String fieldID, String caption,
                             SubsetMeta meta, String referencingEntityName,
                             boolean dynamic) {
        super(fieldType, fieldID, caption);
        this.referencingEntityName = referencingEntityName;
        this.dynamic = dynamic;
        this.availableChoises = meta;
    }

    public BaseListFieldMeta() {
        this(-1, "", "", new SubsetMeta(), "", false); // should pass fieldType
    }

    public SubsetMeta getAvailableChoises() {
        return availableChoises;
    }

    public void setAvailableChoises(SubsetMeta availableChoises) {
        this.availableChoises = availableChoises;
    }

    /**
     * If dynamic, the list of items to choose from will be retrieved
     * everytime the list of chosen items requested. Otherwise,
     * the list of items to choose from will be retrieved once on logon.
     *
     * @return is metadata for that control to be loaded dynamically
     */
    public boolean isDynamic() {
        return dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getReferencingEntityName() {
        return referencingEntityName;
    }

    public void setReferencingEntityName(String referencingEntityName) {
        this.referencingEntityName = referencingEntityName;
    }

    public boolean isEquals(BaseListFieldMeta obj) {
        boolean ret = false;
        if(obj != null) {
            SubsetItemMeta[] items = obj.getAvailableChoises().getItems();
            ret = isItemsEquals(items, availableChoises.getItems());
        }
        return ret;
    }

}
