/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

/**
 * Represent data for a chart field.
 *
 * @author Michael Trofimov
 */
public class ChartFieldData extends BaseFieldData {

	private Long identity;

    public ChartFieldData(String fieldID, Long identity) {
    	super(fieldID);
    	this.identity = identity;
	}
	
	public ChartFieldData(String fieldID) {
		this(fieldID, null);
	}

	public ChartFieldData() {
		this("");
	}

	public void clear() {
		identity = null;
	}

	public FieldData cloneData() {
		return new ChartFieldData(getFieldID(), identity != null ? new Long(identity.longValue()) : null);
	}

	public boolean dataEqualsTo(FieldData data) {
		if (data == this)
			return true;

		boolean answer = false;
		if (data != null && getFieldID().equals(data.getFieldID())
				&& data instanceof ChartFieldData) {

			ChartFieldData _data = (ChartFieldData) data;
			if (_data.isEmpty() && isEmpty()) {
				answer = true;
			} else {
				answer = !_data.isEmpty() && !isEmpty() && identity.equals(_data.identity);
			}
		}
		return answer;
	}

	public boolean isEmpty() {
		return identity == null;
	}

}
