package com.queplix.core.client.app.vo;

import java.util.Map;

import com.queplix.core.client.app.vo.chart.ChartDataItem;
import com.queplix.core.client.app.vo.chart.ChartType;

public class ChartFieldOnDemandData extends BaseFieldOnDemandData {

	// A type of chart (e.g. pie or bar). Required field.
	private ChartType type;
	
	// Image url that represents the chart. Required field.
	private String url;
	// Arrays of chart units data. Required to create image map for chart's image.
	private ChartDataItem[] dataItems;

	// Full-qualified form id of category field.
	// It's used to provide drill-down capability. Optional field.
	private String categoryFieldFormId;
	// Array of full-qualified form ids of data fields.
	// It's used to provide drill-down capability. Optional field.
	private String[] dataFieldFormIds;
	// Collection of filters by full-qualified form id
	private Map/*<String, FieldData[]>*/ filters;
	
	public ChartFieldOnDemandData(
			String fieldID, ChartType type,
					String url, ChartDataItem[] dataItems) {
		super(fieldID);
		this.type = type;
		this.url = url;
		this.dataItems = dataItems;
	}
	
	public ChartFieldOnDemandData(){
		this("", null, null, null);
	}
	
	public ChartType getChartType() {
		return type;
	}
	
	public String getChartUrl() {
		return url;
	}
	
	public ChartDataItem[] getDataItems() {
		return dataItems;
	}

	public String getCategoryFieldFormId() {
		return categoryFieldFormId;
	}

	public void setCategoryFieldFormId(String categoryFieldFormId) {
		this.categoryFieldFormId = categoryFieldFormId;
	}

	public String[] getDataFieldFormIds() {
		return dataFieldFormIds;
	}

	public void setDataFieldFormIds(String[] dataFieldFormIds) {
		this.dataFieldFormIds = dataFieldFormIds;
	}

	/**
	 * Returns array of filters by full-qualified form id
	 */
	public FieldData[] getFilters(String formId){
		return (FieldData[]) filters.get(formId);
	}

	/**
	 * Sets array fo filters by full-qualified form id
	 */
	public void setFilters(String formId, FieldData[] data){
		filters.put(formId, data);
	}
}
