/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import java.util.ArrayList;
import java.util.List;

/**
 * Base request class for all dynamic subset data requests.
 *
 * @author Sergey Kozmin
 * @since 30.01.2007
 */
public class DynamicSubsetDataRequest extends BaseFieldDataRequest {
    private String referencingEntityName = "";
    /**
     * List<FieldData>
     */
    private List additionalFilters;

    /**
     * additional eql filter that will be included to eql request
     */
    private String eqlFilter;

    public DynamicSubsetDataRequest(int theType, String elementID,
                                    String referencingEntityName,
                                    List additionalFilters,
                                    String eqlFilter) {
        super(theType, elementID);
        this.eqlFilter = eqlFilter;
        this.referencingEntityName = referencingEntityName;
        if(this.additionalFilters == null) {
            this.additionalFilters = new ArrayList();
        } else {
            this.additionalFilters = additionalFilters;
        }
    }

    public DynamicSubsetDataRequest(int theType, String elementID,
                                    String referencingEntityName,
                                    List additionalFilters) {
        this(theType, elementID, referencingEntityName, additionalFilters,
                null);
    }


    public DynamicSubsetDataRequest() {
    }

    /**
     * Could not return null
     *
     * @return additional filters for request
     */
    public List getAdditionalFilters() {
        return additionalFilters;
    }

    public void setAdditionalFilters(List additionalFilters) {
        if(additionalFilters != null) {
            this.additionalFilters = additionalFilters;
        }
    }

    public void setAdditionalFilter(FieldData data) {
        additionalFilters.clear();
        additionalFilters.add(data);
    }

    public String getEntityName() {
        return referencingEntityName;
    }

    public void setEntityName(String referencingEntityName) {
        this.referencingEntityName = referencingEntityName;
    }

    public String getEqlFilter() {
        return eqlFilter;
    }

    public void setEqlFilter(String eqlFilter) {
        this.eqlFilter = eqlFilter;
    }
}
