/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * This class contais report element data.
 *
 * @author Aliaksandr Melnik
 * @since 4 Dec 2006
 */
public class EntityElement implements IsSerializable {
    private static final String DIVIDER_CHAR = ".";

    private String formId;
    private String elementId;
    private String elementCaption;

    public EntityElement() {
    }

    public EntityElement(String formId, String elementId,
                         String elementCaption) {
        this.elementCaption = elementCaption;
        this.formId = formId;
        this.elementId = elementId;
    }

    public String getFormId() {
        return formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getElementId() {
        return elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getElementCaption() {
        return elementCaption;
    }

    public void setElementCaption(String elementCaption) {
        this.elementCaption = elementCaption;
    }

    public String getElementKey() {
        return getElementKey(formId, elementId);
    }

    public static String getElementKey(String formId, String elementId) {
        return formId + DIVIDER_CHAR + elementId;
    }
}
