/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import java.util.HashSet;
import java.util.Set;

/**
 * Data container for EntityLink field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class EntityLinkFieldData extends BaseFieldData {
    public static final Long EMPTY_VALUE = new Long(-10000);

    private Long currentEntityID;
    /**
     * Set of Longs. All linked ids is in it.
     */
    private Set linkedEntityIDs;

    public EntityLinkFieldData(String fieldID, Long currentEntityID,
                               Set linkedEntityIDs) {
        super(fieldID);
        setCurrentEntityID(currentEntityID);
        setLinkedEntityIDs(linkedEntityIDs);
    }

    public EntityLinkFieldData(String fieldID) {
        this(fieldID, null, null);
    }

    public EntityLinkFieldData() {
        this("");
    }

    public Long getCurrentEntityID() {
        return currentEntityID;
    }

    public void setCurrentEntityID(Long currentEntityID) {
        if(currentEntityID != null) {
            this.currentEntityID = currentEntityID;
        } else {
            this.currentEntityID = EMPTY_VALUE;
        }
    }

    public Set getLinkedEntityIDs() {
        return linkedEntityIDs;
    }

    public void setLinkedEntityIDs(Set linkedEntityIDs) {
        if(linkedEntityIDs != null) {
            this.linkedEntityIDs = linkedEntityIDs;
        } else {
            this.linkedEntityIDs = new HashSet();
        }
    }

    public boolean isEmpty() {
        return currentEntityID.equals(EMPTY_VALUE) && (linkedEntityIDs.size()
                == 0);
    }

    public void clear() {
        currentEntityID = EMPTY_VALUE;
        linkedEntityIDs = new HashSet();
    }

    public FieldData cloneData() {
        return new EntityLinkFieldData(getFieldID(), currentEntityID,
                linkedEntityIDs);
    }

    public boolean dataEqualsTo(FieldData data) {
        boolean ret = false;
        if(data != null && data.getFieldID().equalsIgnoreCase(getFieldID())) {
            //assume that if ids are equal, then control types are equal too (within one form)
            EntityLinkFieldData castData = (EntityLinkFieldData) data;
            ret = castData.currentEntityID.equals(currentEntityID) &&
                    castData.linkedEntityIDs.equals(linkedEntityIDs);
        }
        return ret;
    }
}
