/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

/**
 * MetaData container for entity reference field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class EntityReferenceMeta extends BaseFieldMeta {
    private GridMeta meta;
    private String referencedEntityName;

    public EntityReferenceMeta(String fieldID, String caption, GridMeta meta,
                               String referencedEntityName) {
        super(ENTITYREFERENCE, fieldID, caption);
        this.meta = meta;
        this.referencedEntityName = referencedEntityName;
    }

    public EntityReferenceMeta() {
        this("", "", new GridMeta(), "");
    }

    public GridMeta getMeta() {
        return meta;
    }

    public void setMeta(GridMeta meta) {
        this.meta = meta;
    }

    public String getReferencedEntityName() {
        return referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }
}
