/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Base interface, that dermine concrete type of the DataRequest class.
 *
 * @author Sergey Kozmin
 * @since 08.11.2006, 18:39:03
 */
public interface FieldDataRequest extends IsSerializable {

	/**
     * @return the type of concrete implementation class.
     * @see FieldType
     */
    public int getRequestType();

    /**
     * @return element, that need data
     */
    public String getElementID();

    /**
     * @return array of request filters
     */
    public EntityData[] getFilters();

    /**
     * Adds filter to the request
     */
    public void addFilter(EntityData filter);
}
