/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

/**
 * In form grid request for the type {@link #GET_RECORDS_DATA_TYPE}.
 *
 * @author Sergey Kozmin
 * @since 04.04.2007
 */
public class GetRecordsDataInformRequest extends InFormDataRequest {
    /**
     * Collection of the records id's. Collection<Long>
     */
    private RecordFilter filter;

    public GetRecordsDataInformRequest(String elementID, RecordFilter filter,
                                       String requestingEntity) {
        super(elementID, GET_RECORDS_DATA_TYPE, requestingEntity);
        setFilter(filter);
    }

    public GetRecordsDataInformRequest() {
        this("", null, "");
    }

    public RecordFilter getFilter() {
        return filter;
    }

    public void setFilter(RecordFilter filter) {
        if(filter != null) {
            this.filter = filter;
        } else {
            this.filter = RecordFilter.createFieldsFilter(null);
        }
    }
}
