/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.app.vo.uisettings.GridUISettings;

import java.util.HashMap;
import java.util.Map;

/**
 * Grid-related metadata
 *
 * @author Aliaksandr Melnik
 * @since 18 Oct 2006
 */
public class GridMeta implements IsSerializable {
    private FamgMeta.Index index;
    private FieldMeta[] fields;
    private SubsetData columns;
    private GridUISettings uiSettings;

    public GridMeta(FieldMeta[] fields, long[] selectedIDs,
                    GridUISettings uiSettings) {
        if(fields != null) {
            this.fields = fields;
        } else {
            this.fields = new FieldMeta[0];
        }
        this.columns = new SubsetData(selectedIDs);
        this.uiSettings = uiSettings;
    }

    public GridMeta(FieldMeta[] fields, long[] selectedIDs) {
        this(fields, selectedIDs, null);
    }

    public GridMeta(FieldMeta[] fields) {
        this(fields, new long[0]);
    }

    public GridMeta() {
        this(null);
    }

    public FamgMeta.Index getIndex() {
        return index;
    }

    public void setIndex(FamgMeta.Index index) {
        this.index = index;
    }

    public FieldMeta[] getFields() {
        return fields;
    }

    public void setFields(FieldMeta[] fields) {
        this.fields = fields;
    }

    public SubsetData getColumns() {
        return columns;
    }

    public SubsetData cloneColumns() {
        return columns.clone2();
    }

    public void setColumns(SubsetData columns) {
        this.columns = columns;
    }

    public int getColumnsCount() {
        return columns.getSelectedIDs().length;
    }

    public GridUISettings getUISettings() {
        return uiSettings;
    }

    public void setUISettings(GridUISettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    public GridUISettings getOrCreateUISettings() {
        if(uiSettings == null) {
            uiSettings = new GridUISettings();
        }
        return uiSettings;
    }

    public Map getOrCreateColumnWidths() {
        getOrCreateUISettings();
        Map result = uiSettings.getColumnWidths();
        if(result == null) {
            result = new HashMap();
            uiSettings.setColumnWidths(result);
        }
        return result;
    }

    public int getFieldIndex(String fieldID) {
        int i = fields.length - 1;
        while(i > -1 && !fields[i].getFieldID().equals(fieldID)) {
            i--;
        }
        return i;
    }
}
