/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Contain all the request properties that grid manages.
 *
 * @author Sergey Kozmin
 * @since 12.04.2007
 */
public class GridSearchProperties implements IsSerializable {
    public final static int DEFAULT_PAGE = 0;
    public final static int DEFAULT_PAGE_SIZE = 20;
    public final static boolean DEFAULT_DOCOUNT = false;

    private boolean doCount = DEFAULT_DOCOUNT;
    private int page = DEFAULT_PAGE;
    private int pageSize = DEFAULT_PAGE_SIZE;
    private SortField sortField;

    public GridSearchProperties(boolean doCount, int page, int pageSize,
                                SortField sortField) {
        this.doCount = doCount;
        this.page = page;
        this.pageSize = pageSize;
        this.sortField = sortField;
    }

    public GridSearchProperties() {
    }

    public boolean isDoCount() {
        return doCount;
    }

    public void setDoCount(boolean doCount) {
        this.doCount = doCount;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public SortField getSortField() {
        return sortField;
    }

    public void setSortField(SortField sortField) {
        this.sortField = sortField;
    }
}
