/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

/**
 * History request.
 *
 * @author Sergey Kozmin
 * @since 08.11.2006, 19:27:59
 */
public class HistoryDataRequest extends BaseFieldDataRequest {
    private long recordId;

    public HistoryDataRequest(String fieldId, long recordId) {
        super(FieldType.HISTORY, fieldId);
        this.recordId = recordId;
    }

    public HistoryDataRequest() {
        this("", -1);
    }

    public long getRecordId() {
        return recordId;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

}
