/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

/**
 * In-form grid abstract request. Defines types of it's request
 *
 * @author Sergey Kozmin
 * @since 08.11.2007, 19:27:59
 */
public abstract class InFormDataRequest extends BaseFieldDataRequest
        implements InFormGridType {
    /**
     * Can be one of the listed in the
     * {@link com.queplix.core.client.app.vo.InFormGridType}
     */
    private int informReqType;
    /**
     * Relating entity name
     */
    private String requestingEntity;

    protected InFormDataRequest(String elementID, int informReqType,
                                String requestingEntity) {
        super(FieldType.IN_FORM_GRID, elementID);
        this.requestingEntity = requestingEntity;
        this.informReqType = informReqType;
    }

    public InFormDataRequest() {
        this("", SEARCH_TYPE, "");
    }

    public int getInformGridRequestType() {
        return informReqType;
    }

    public String getRequestingEntity() {
        return requestingEntity;
    }
}
