/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.queplix.core.client.app.vo.util.InvariantDate;

import java.util.Date;

/**
 * This class contains data for Login Request
 *
 * @author Aliaksandr Melnik
 * @since 27 Dec 2006
 */
public class LoginRequestObject implements IsSerializable {
    private String login;
    private String password;
    private String portalType;
    private InvariantDate clientNow;

    public LoginRequestObject() {
    }

    public LoginRequestObject(String login, String password, String portalType) {
        this.login = login;
        this.password = password;
        this.setPortalType(portalType);
        clientNow = InvariantDate.fromDate(new Date());
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public InvariantDate getClientNow() {
        return clientNow;
    }

    public String getPortalType() {
        return portalType;
    }

    public void setPortalType(String portalType) {
        this.portalType = portalType;
    }

}
