/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * That class contains all more data response.
 *
 * @author Sergey Kozmin
 * @since 01.11.2006, 14:49:13
 */
public class MoreDataResponseObject implements IsSerializable {
    private FieldOnDemandData fieldData;

    /**
     * Construct the response object with the given parameters
     *
     * @param fieldData see super class
     */
    public MoreDataResponseObject(FieldOnDemandData fieldData) {
        this.fieldData = fieldData;
    }

    /**
     * Construct failed response, with apropriate message
     */
    public MoreDataResponseObject() {
        this(null);
    }

    /**
     * Return object. can be null object
     *
     * @return field data
     */
    public FieldOnDemandData getFieldData() {
        return fieldData;
    }

    public void setFieldData(FieldOnDemandData fieldData) {
        if(fieldData != null) {
            this.fieldData = fieldData;
        }
    }
}
