/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo;

import com.queplix.core.client.common.CollectionsHelper;

import java.util.Collection;

/**
 * In form grid request for the type {@link #SEARCH_TYPE}.
 *
 * @author Sergey Kozmin
 * @since 04.04.2007
 */
public class SearchInformRequest extends InFormDataRequest {
    /**
     * filters for the filtering entity. Collection<FieldData>
     */
    private Collection fieldsFilters;
    /**
     * Searching properties.
     */
    private GridSearchProperties gridProperties;

    public SearchInformRequest(String elementID, Collection fieldsFilters,
                               String requestingEntity,
                               GridSearchProperties gridProperties) {
        super(elementID, SEARCH_TYPE, requestingEntity);
        this.gridProperties = gridProperties;
        setFieldsFilters(fieldsFilters);
        setGridProperties(gridProperties);
    }

    public SearchInformRequest() {
        this("", null, "", null);
    }

    public Collection getFieldsFilters() {
        return fieldsFilters;
    }

    public void setFieldsFilters(Collection fieldsFilters) {
        if(fieldsFilters != null) {
            this.fieldsFilters = fieldsFilters;
        } else {
            this.fieldsFilters = CollectionsHelper.emptyCollection();
        }
    }

    public GridSearchProperties getGridProperties() {
        return gridProperties;
    }

    public void setGridProperties(GridSearchProperties gridProperties) {
        if(gridProperties != null) {
            this.gridProperties = gridProperties;
        } else {
            this.gridProperties = new GridSearchProperties();
        }
    }
}
