/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo.chart;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.ArrayList;
import java.util.List;

public class ChartData implements IsSerializable {

    private String url;
    private List/*<ChartDataItem>*/ dataItems
            = new ArrayList/*<ChartDataItem>*/();

    public ChartData() {
    }

    public ChartData(String url) {
        this.url = url;
    }

    public ChartData(String url, List/*<ChartDataItem>*/ dataItems) {
        this(url);
        if(dataItems != null) {
            this.dataItems = dataItems;
        }
    }

    public String getUrl() {
        return url;
    }

    public List/*<ChartDataItem>*/ getDataItems() {
        return dataItems;
    }

}
