/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.client.app.vo.chart;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChartMeta implements IsSerializable {

    private Long id;
    private ChartType type;
    private int width;
    private int height;
    private boolean empty = false;

    // full-qualified category field's form id
    private String categoryFieldFormId;
    // collection of full-qualified data field's form ids
    private List/*<String>*/ dataFieldFormIds = new ArrayList/*<String>*/();

    // formId => list of filters
    private Map/*<String, List<FieldData>>*/ filters
            = new HashMap/*<String, List<FieldData>>*/();


    public ChartMeta() {
    }

    public ChartMeta(Long id) {
        if(id == null) {
            throw new IllegalArgumentException("id can't be a null");
        }

        this.id = id;
    }

    public Long getID() {
        return id;
    }

    public ChartType getType() {
        return type;
    }

    public void setType(ChartType type) {
        if(type == null) {
            throw new IllegalArgumentException("type can't be a null");
        }

        this.type = type;
    }

    public Map/*<String, List<FieldData>>*/ getFilters() {
        return filters;
    }

    public void setFilters(Map/*<String, List<FieldData>>*/ filters) {
        if(filters != null) {
            this.filters = filters;
        }
    }

    /**
     * Returns full-qualified category field's form id
     */
    public String getCategoryFieldFormId() {
        return categoryFieldFormId;
    }

    /**
     * Sets full-qualified category field's form id
     */
    public void setCategoryFieldFormId(String categoryFieldFormId) {
        this.categoryFieldFormId = categoryFieldFormId;
    }

    /**
     * Returns collection of full-qualified data field's form ids
     */
    public List/*<String>*/ getDataFieldFormIds() {
        return dataFieldFormIds;
    }

    /**
     * Sets collection of full-qualified data field's form ids
     */
    public void setDataFieldFormIds(List/*<String>*/ dataFieldFormIds) {
        if(dataFieldFormIds != null) {
            this.dataFieldFormIds = dataFieldFormIds;
        }
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String toString() {
        return "[id=" + id + ", type=" + type + ", filters=" + filters + "]";
    }

	public boolean isEmpty() {
		return empty;
	}

	public void setEmpty(boolean empty) {
		this.empty = empty;
	}

}
