/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */

package com.queplix.core.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Web access task.
 *
 * @author Sultan Tezadov
 */
public class WebTask extends Task {
    private String url;
    private String resultProperty;
    private boolean textOnly;

    public void execute() throws BuildException {
        try {
            String response = readFromUrl(url);
            if(textOnly) {
                response = extractText(response);
            }
            PropertyHelper ph = PropertyHelper.getPropertyHelper(getProject());
            ph.setNewProperty(null, resultProperty, response);
        } catch (MalformedURLException ex) {
            throw new BuildException(ex);
        } catch (IOException ex) {
            throw new BuildException(ex);
        }
    }

    private String readFromUrl(String url) throws IOException {
        URL urlObject = new URL(url);
        InputStream is = urlObject.openStream();
        InputStreamReader isr = new InputStreamReader(is);
        char[] buffer = new char[8192];
        StringBuffer sb = new StringBuffer();
        int n;
        while((n = isr.read(buffer)) != -1) {
            sb.append(buffer, 0, n);
        }
        return sb.toString();
    }

    private String extractText(String html) {
        StringBuffer sbItem = new StringBuffer();
        StringBuffer sbResult = new StringBuffer();
        boolean inTag = false;
        for(int i = 0; i < html.length(); i++) {
            char ch = html.charAt(i);
            if(inTag) {
                if(ch == '>') {
                    inTag = false;
                }
            } else {
                if(ch == '<') {
                    inTag = true;
                    String item = sbItem.toString();
                    item = item.trim();
                    if(item.length() > 0) {
                        item += "\n";
                        sbResult.append(item);
                    }
                    sbItem = new StringBuffer();
                } else {
                    sbItem.append(ch);
                }
            }
        }
        sbResult.append(sbItem);
        return sbResult.toString();
    }


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getResultProperty() {
        return resultProperty;
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    public boolean isTextOnly() {
        return textOnly;
    }

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }

}
